/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.util.Arrays;
import net.java.truevfs.comp.zip.LittleEndian;
import org.junit.Assert;
import org.junit.Test;

public final class LittleEndianTest {
    private final byte[] read = new byte[]{0, 85, -86, 85, -86, 85, -86, 85, -86};
    private final byte[] write = new byte[this.read.length];

    @Test
    public void testByte() {
        byte b1 = LittleEndian.readByte((byte[])this.read, (int)1);
        byte b2 = LittleEndian.readByte((byte[])this.read, (int)2);
        Assert.assertEquals((long)85L, (long)b1);
        Assert.assertEquals((long)-86L, (long)b2);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)1);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)2);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)3);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)4);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)5);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)6);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)7);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)8);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testUByte() {
        int b1 = LittleEndian.readUByte((byte[])this.read, (int)1);
        int b2 = LittleEndian.readUByte((byte[])this.read, (int)2);
        Assert.assertEquals((long)85L, (long)b1);
        Assert.assertEquals((long)170L, (long)b2);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)1);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)2);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)3);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)4);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)5);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)6);
        LittleEndian.writeByte((int)b1, (byte[])this.write, (int)7);
        LittleEndian.writeByte((int)b2, (byte[])this.write, (int)8);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testShort() {
        int s = LittleEndian.readShort((byte[])this.read, (int)1);
        Assert.assertEquals((long)-21931L, (long)s);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)1);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)3);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)5);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)7);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testUShort() {
        int s = LittleEndian.readUShort((byte[])this.read, (int)1);
        Assert.assertEquals((long)43605L, (long)s);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)1);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)3);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)5);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)7);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testInt() {
        int i = LittleEndian.readInt((byte[])this.read, (int)1);
        Assert.assertEquals((long)-1437226411L, (long)i);
        LittleEndian.writeInt((int)i, (byte[])this.write, (int)1);
        LittleEndian.writeInt((int)i, (byte[])this.write, (int)5);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testUInt() {
        long i = LittleEndian.readUInt((byte[])this.read, (int)1);
        Assert.assertEquals((long)0xAA55AA55L, (long)i);
        LittleEndian.writeInt((int)((int)i), (byte[])this.write, (int)1);
        LittleEndian.writeInt((int)((int)i), (byte[])this.write, (int)5);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testLong() {
        long l = LittleEndian.readLong((byte[])this.read, (int)1);
        Assert.assertEquals((long)-6172840429334713771L, (long)l);
        LittleEndian.writeLong((long)l, (byte[])this.write, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }
}

