/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.util.Arrays;
import net.java.truevfs.comp.zip.DefaultExtraField;
import net.java.truevfs.comp.zip.ExtraField;
import net.java.truevfs.comp.zip.ExtraFields;
import org.junit.Assert;
import org.junit.Test;

public final class ExtraFieldsTest {
    private final byte[] serialized = new byte[]{0, 0, 0, 0, 1, 0, 28, 0, 33, 67, 101, -121, -87, -53, -19, 15, 33, 67, 101, -121, -87, -53, -19, 15, 33, 67, 101, -121, -87, -53, -19, 15, 33, 67, 101, -121, -2, -54, 0, 0};
    private final ExtraFields fields = new ExtraFields();

    @Test
    public void testGetSet() {
        Assert.assertEquals((long)0L, (long)this.fields.getDataBlock().length);
        this.fields.readFrom(this.serialized, 0, this.serialized.length);
        Assert.assertEquals((long)this.serialized.length, (long)this.fields.getDataSize());
        this.serialized[0] = -1;
        byte[] got1 = this.fields.getDataBlock();
        Assert.assertNotNull((Object)got1);
        Assert.assertNotSame((Object)this.serialized, (Object)got1);
        byte[] got2 = this.fields.getDataBlock();
        Assert.assertNotNull((Object)got2);
        Assert.assertNotSame((Object)this.serialized, (Object)got2);
        Assert.assertNotSame((Object)got1, (Object)got2);
        this.serialized[0] = 0;
        Assert.assertTrue((boolean)Arrays.equals(this.serialized, got1));
        Assert.assertTrue((boolean)Arrays.equals(this.serialized, got2));
    }

    @Test
    public void testCollection0() {
        this.fields.readFrom(this.serialized, 0, this.serialized.length);
        ExtraField ef = this.fields.get(1);
        Assert.assertNotNull((Object)ef);
        Assert.assertSame((Object)ef, (Object)this.fields.remove(1));
        Assert.assertNull((Object)this.fields.get(1));
        Assert.assertNull((Object)this.fields.add(ef));
        byte[] got = this.fields.getDataBlock();
        Assert.assertNotSame((Object)this.serialized, (Object)got);
        Assert.assertTrue((boolean)Arrays.equals(this.serialized, got));
    }

    @Test
    public void testCollection1() {
        Assert.assertEquals((long)0L, (long)this.fields.getDataBlock().length);
        DefaultExtraField ef = new DefaultExtraField(1);
        Assert.assertNull((Object)this.fields.get(1));
        Assert.assertNull((Object)this.fields.add((ExtraField)ef));
        byte[] got = this.fields.getDataBlock();
        Assert.assertEquals((long)(4 + ef.getDataSize()), (long)got.length);
        Assert.assertSame((Object)ef, (Object)this.fields.remove(1));
        Assert.assertEquals((long)0L, (long)this.fields.getDataBlock().length);
    }
}

