/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import net.java.truevfs.comp.zip.DefaultExtraField;
import net.java.truevfs.comp.zip.ExtraField;
import org.junit.Assert;
import org.junit.Test;

public final class ExtraFieldTest {
    @Test
    public void testRegister() {
        try {
            ExtraField.register(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            ExtraField.register(TooSmallHeaderIDExtraField.class);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            ExtraField.register(TooLargeHeaderIDExtraField.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ExtraField.register(NullExtraField.class);
    }

    @Test
    public void testCreate() {
        ExtraField.register(NullExtraField.class);
        ExtraField ef = ExtraField.create((int)0);
        Assert.assertTrue((boolean)(ef instanceof NullExtraField));
        Assert.assertEquals((long)0L, (long)ef.getHeaderId());
        ef = ExtraField.create((int)1);
        Assert.assertTrue((boolean)(ef instanceof DefaultExtraField));
        Assert.assertEquals((long)1L, (long)ef.getHeaderId());
        ef = ExtraField.create((int)2);
        Assert.assertTrue((boolean)(ef instanceof DefaultExtraField));
        Assert.assertEquals((long)2L, (long)ef.getHeaderId());
        ef = ExtraField.create((int)65535);
        Assert.assertTrue((boolean)(ef instanceof DefaultExtraField));
        Assert.assertEquals((long)65535L, (long)ef.getHeaderId());
        try {
            ef = ExtraField.create((int)-1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            ef = ExtraField.create((int)65536);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static final class TooLargeHeaderIDExtraField
    extends NullExtraField {
        private TooLargeHeaderIDExtraField() {
        }

        @Override
        public int getHeaderId() {
            return 65536;
        }
    }

    private static final class TooSmallHeaderIDExtraField
    extends NullExtraField {
        private TooSmallHeaderIDExtraField() {
        }

        @Override
        public int getHeaderId() {
            return -1;
        }
    }

    private static class NullExtraField
    extends ExtraField {
        public int getHeaderId() {
            return 0;
        }

        int getDataSize() {
            return 0;
        }

        void readFrom(byte[] buf, int off, int len) {
        }

        void writeTo(byte[] buf, int off) {
        }
    }
}

