/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.util.Arrays;
import net.java.truevfs.comp.zip.DefaultExtraField;
import org.junit.Assert;
import org.junit.Test;

public final class DefaultExtraFieldTest {
    private DefaultExtraField field = new DefaultExtraField(0);

    @Test
    public void testConstructor() {
        try {
            this.field = new DefaultExtraField(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.field = new DefaultExtraField(65536);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.field = new DefaultExtraField(0);
        Assert.assertEquals((long)0L, (long)this.field.getHeaderId());
        Assert.assertEquals((long)0L, (long)this.field.getDataSize());
        this.field = new DefaultExtraField(65535);
        Assert.assertEquals((long)65535L, (long)this.field.getHeaderId());
        Assert.assertEquals((long)0L, (long)this.field.getDataSize());
    }

    @Test
    public void testGetDataSize() {
        Assert.assertEquals((long)0L, (long)this.field.getDataSize());
    }

    @Test
    public void testGetDataBlock() {
        Assert.assertEquals((long)0L, (long)this.field.getDataBlock().length);
    }

    @Test
    public void testReadWrite() {
        byte[] read = new byte[11];
        try {
            this.field.readFrom(read, 1, -1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.field.readFrom(read, 1, read.length);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            this.field.readFrom(read, read.length, 1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            this.field.readFrom(read, 1, 65536);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.field.readFrom(read, 1, read.length - 1);
        Assert.assertEquals((long)(read.length - 1), (long)this.field.getDataSize());
        read[1] = -1;
        byte[] write = new byte[11];
        this.field.writeTo(write, 1);
        read[1] = 0;
        Assert.assertTrue((boolean)Arrays.equals(read, write));
    }
}

