/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.sample;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileInputStream;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncWarningException;

abstract class FileUsage {
    private FileUsage() {
    }

    void cat1(String path) throws IOException {
        try (TFileInputStream in = new TFileInputStream(path);){
            TFile.cat((InputStream)in, (OutputStream)System.out);
        }
    }

    void cat2(String path) {
        try (TFileInputStream in = new TFileInputStream(path);){
            TFile.cat((InputStream)in, (OutputStream)System.out);
        }
        catch (IOException ouch) {
            ouch.printStackTrace();
        }
    }

    void umount1() {
        try {
            TVFS.umount();
        }
        catch (FsSyncException ouch) {
            ouch.printStackTrace();
        }
    }

    void umount2() {
        try {
            TVFS.umount();
        }
        catch (FsSyncWarningException oops) {
        }
        catch (FsSyncException ouch) {
            ouch.printStackTrace();
        }
    }

    void performance1() throws IOException {
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
            TVFS.umount();
        }
    }

    void performance2() throws IOException {
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
        }
        TVFS.umount();
    }

    void performance3() throws IOException {
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
            entry.createNewFile();
        }
    }

    void performance4() throws IOException {
        long time = System.currentTimeMillis();
        String[] names = new String[]{"a", "b", "c"};
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            TFile entry = new TFile("archive.zip", names[i]);
            entry.createNewFile();
            entry.setLastModified(time);
        }
    }
}

