/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.it;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import net.java.truecommons.io.ClosedInputException;
import net.java.truecommons.io.ClosedOutputException;
import net.java.truecommons.io.Streams;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.ConcurrencyUtils;
import net.java.truevfs.access.ConfiguredClientTestBase;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TPath;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsOpenResourceException;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.FsSyncWarningException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TPathITSuite<D extends FsArchiveDriver<?>>
extends ConfiguredClientTestBase<D> {
    private static final Logger logger = LoggerFactory.getLogger(TPathITSuite.class);
    private static final String TEMP_FILE_PREFIX = "tzp-path";
    private Path temp;
    private TPath archive;
    private static final String[] MEMBERS = new String[]{"A directory member", "Another directory member", "Yet another directory member"};

    @Override
    public void setUp() throws IOException {
        super.setUp();
        this.temp = this.createTempFile();
        Files.delete(this.temp);
        this.archive = new TPath(this.temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        try {
            try {
                this.umount();
            }
            finally {
                this.archive = null;
                Path temp = this.temp;
                this.temp = null;
                if (null != temp && Files.exists(temp, new LinkOption[0])) {
                    Files.delete(temp);
                }
            }
        }
        catch (IOException ex) {
            logger.trace("Failed to clean up test file (this may be just an aftermath):", (Throwable)ex);
        }
        finally {
            super.tearDown();
        }
    }

    protected final TPath getArchive() {
        return this.archive;
    }

    protected final void umount() throws FsSyncException {
        if (null != this.archive) {
            this.archive.getFileSystem().close();
        }
    }

    private Path createTempFile() throws IOException {
        return Files.createTempFile(TEMP_FILE_PREFIX, this.getExtension(), new FileAttribute[0]).toRealPath(new LinkOption[0]);
    }

    protected final void createTestFile(TPath path) throws IOException {
        try (OutputStream out = Files.newOutputStream((Path)path, new OpenOption[0]);){
            out.write(this.getData());
        }
    }

    protected final void verifyTestFile(TPath path) throws IOException {
        Assert.assertEquals((long)this.getDataLength(), (long)Files.size((Path)path));
        byte[] array = new byte[this.getDataLength()];
        try (InputStream in = Files.newInputStream((Path)path, new OpenOption[0]);){
            new DataInputStream(in).readFully(array);
        }
        Assert.assertArrayEquals((byte[])this.getData(), (byte[])array);
    }

    @Test
    public void testArchiveControllerStateWithInputStream() throws IOException, InterruptedException {
        this.assertArchiveControllerStateWithResource((Factory<Closeable, String, IOException>)new Factory<InputStream, String, IOException>(){

            @Override
            public InputStream create(String entry) throws IOException {
                return Files.newInputStream((Path)new TPath(entry, new String[0]), new OpenOption[0]);
            }
        });
    }

    @Test
    public void testArchiveControllerStateWithOutputStream() throws IOException, InterruptedException {
        this.assertArchiveControllerStateWithResource((Factory<Closeable, String, IOException>)new Factory<OutputStream, String, IOException>(){

            @Override
            public OutputStream create(String entry) throws IOException {
                return Files.newOutputStream((Path)new TPath(entry, new String[0]), new OpenOption[0]);
            }
        });
    }

    private void assertArchiveControllerStateWithResource(Factory<? extends Closeable, ? super String, ? extends IOException> factory) throws IOException, InterruptedException {
        Reference<FsController> got;
        String entry = this.archive + "/entry";
        this.archive = null;
        Files.createFile((Path)new TPath(entry, new String[0]), new FileAttribute[0]);
        TVFS.umount((TFile)new TFile(entry).getTopLevelArchive());
        ReferenceQueue<FsController> queue = new ReferenceQueue<FsController>();
        Reference<FsController> reference = this.assertReferenceForResource(factory, entry, queue);
        System.gc();
        Assert.assertNull(queue.remove(50L));
        Assert.assertSame((Object)reference.get(), (Object)this.controller(new TPath(entry, new String[0]).getNodePath()));
        TVFS.umount((TFile)new TFile(entry).getTopLevelArchive());
        do {
            System.gc();
        } while (null == (got = queue.remove(50L)));
        assert (reference == got);
        assert (null == reference.get());
    }

    private Reference<FsController> assertReferenceForResource(Factory<? extends Closeable, ? super String, ? extends IOException> factory, String entry, ReferenceQueue<FsController> queue) throws IOException, InterruptedException {
        WeakReference<FsController> reference;
        try (Closeable resource = factory.create(entry);){
            reference = new WeakReference<FsController>(this.controller(new TPath(entry, new String[0]).getNodePath()), queue);
            System.gc();
            Assert.assertNull(queue.remove(50L));
            Assert.assertSame(reference.get(), (Object)this.controller(new TPath(entry, new String[0]).getNodePath()));
        }
        return reference;
    }

    @Test
    public void testFalsePositives() throws IOException {
        this.assertFalsePositive(this.archive);
        TPath entry = this.archive.resolve("entry" + this.getExtension());
        Files.createDirectory((Path)this.archive.toNonArchivePath(), new FileAttribute[0]);
        this.assertFalsePositive(entry);
        Files.delete((Path)this.archive);
        Files.createDirectory((Path)this.archive, new FileAttribute[0]);
        this.assertFalsePositive(entry);
        Files.delete((Path)this.archive);
    }

    private void assertFalsePositive(TPath file) throws IOException {
        block25: {
            block24: {
                assert (file.isArchive());
                this.createTestFile(file);
                this.createTestFile(file);
                Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
                Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
                Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
                Assert.assertEquals((long)this.getDataLength(), (long)Files.size((Path)file));
                Assert.assertTrue((Files.getLastModifiedTime((Path)file, new LinkOption[0]).toMillis() > 0L ? 1 : 0) != 0);
                try (InputStream in = Files.newInputStream((Path)file, new OpenOption[0]);){
                    byte[] buf = new byte[this.getDataLength()];
                    int read = in.read(buf);
                    Assert.assertEquals((Object)ByteBuffer.wrap(this.getData(), 0, read), (Object)ByteBuffer.wrap(buf, 0, read));
                }
                this.assertRm(file);
                Files.createDirectory((Path)file.toNonArchivePath(), new FileAttribute[0]);
                Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
                Assert.assertTrue((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
                Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
                Assert.assertTrue((Files.getLastModifiedTime((Path)file, new LinkOption[0]).toMillis() > 0L ? 1 : 0) != 0);
                try {
                    Files.newInputStream((Path)this.archive, new OpenOption[0]).close();
                    if ('\\' == File.separatorChar) {
                        Assert.fail();
                    }
                }
                catch (IOException ex) {
                    if ('\\' == File.separatorChar || this.archive.isArchive()) break block24;
                    throw ex;
                }
            }
            try {
                Files.newOutputStream((Path)this.archive, new OpenOption[0]).close();
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            this.assertRm(file);
            Files.createDirectory((Path)file, new FileAttribute[0]);
            Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
            Assert.assertTrue((Files.getLastModifiedTime((Path)file, new LinkOption[0]).toMillis() > 0L ? 1 : 0) != 0);
            try {
                Files.newInputStream((Path)this.archive, new OpenOption[0]).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (IOException ex) {
                if ('\\' == File.separatorChar || this.archive.isArchive() || this.archive.isEntry()) break block25;
                throw ex;
            }
        }
        try {
            Files.newOutputStream((Path)this.archive, new OpenOption[0]).close();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.assertRm(file);
    }

    private void assertRm(TPath file) throws IOException {
        Files.delete((Path)file);
        Assert.assertFalse((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        try {
            Files.size((Path)file);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
        try {
            Files.getLastModifiedTime((Path)file, new LinkOption[0]);
            Assert.fail();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateNewFile() throws IOException {
        this.assertCreateNewPlainFile();
        this.assertCreateNewEnhancedFile();
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewPlainFile() throws IOException {
        Path archive = this.createTempFile();
        Files.delete(archive);
        Path file1 = archive.resolve("test.txt");
        Path file2 = file1.resolve("test.txt");
        try {
            Files.createFile(file1, new FileAttribute[0]);
            Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        this.assertCreateNewFile(archive, file1, file2);
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewEnhancedFile() throws IOException {
        TPath file1 = this.archive.resolve("test.txt");
        TPath file2 = file1.resolve("test.txt");
        try (TConfig config = TConfig.open();){
            config.setLenient(false);
            try {
                Files.createFile((Path)file1, new FileAttribute[0]);
                Assert.fail((String)"Creating a file in a non-existent directory should throw an IOException!");
            }
            catch (IOException expected) {
                // empty catch block
            }
            this.assertCreateNewFile((Path)this.archive, (Path)file1, (Path)file2);
        }
        this.assertCreateNewFile((Path)this.archive, (Path)file1, (Path)file2);
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void assertCreateNewFile(Path dir, Path file1, Path file2) throws IOException {
        TPath tdir;
        Assert.assertFalse((boolean)Files.exists(dir, new LinkOption[0]));
        Files.createDirectory(dir, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(dir, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isDirectory(dir, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile(dir, new LinkOption[0]));
        if (dir instanceof TPath && ((tdir = (TPath)dir).isArchive() || tdir.isEntry())) {
            Assert.assertEquals((long)0L, (long)Files.size(dir));
        }
        Files.createFile(file1, new FileAttribute[0]);
        Assert.assertTrue((boolean)Files.exists(file1, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory(file1, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isRegularFile(file1, new LinkOption[0]));
        Assert.assertEquals((long)0L, (long)Files.size(file1));
        try {
            Files.createFile(file2, new FileAttribute[0]);
            Assert.fail((String)"Creating a file in another file should throw an IOException!");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Files.delete(file1);
        Assert.assertFalse((boolean)Files.exists(file1, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory(file1, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile(file1, new LinkOption[0]));
        try {
            Files.size(file1);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
        Files.delete(dir);
        Assert.assertFalse((boolean)Files.exists(dir, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory(dir, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile(dir, new LinkOption[0]));
        try {
            Files.size(dir);
            Assert.fail();
        }
        catch (NoSuchFileException expected) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegalDirectoryOperations() throws IOException {
        try {
            String[] names = new String[]{"inner" + this.getExtension(), "dir"};
            TPath file = this.archive;
            for (int i = 0; i <= names.length; ++i) {
                TPath file2 = file.toNonArchivePath();
                Files.createDirectory((Path)file2, new FileAttribute[0]);
                this.assertIllegalDirectoryOperations(file2);
                Files.delete((Path)file2);
                Files.createDirectory((Path)file, new FileAttribute[0]);
                this.assertIllegalDirectoryOperations(file);
                if (i >= names.length) continue;
                file = file.resolve(names[i]);
            }
        }
        finally {
            this.archive.toFile().rm_r();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIllegalDirectoryOperations(TPath dir) throws IOException {
        block13: {
            assert (Files.isDirectory((Path)dir, new LinkOption[0]));
            try {
                Files.newInputStream((Path)dir, new OpenOption[0]).close();
                if ('\\' == File.separatorChar) {
                    Assert.fail();
                }
            }
            catch (IOException ex) {
                if ('\\' == File.separatorChar || dir.isArchive() || dir.isEntry()) break block13;
                throw ex;
            }
        }
        try {
            Files.newOutputStream((Path)dir, new OpenOption[0]).close();
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        Path tmp = Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]);
        try {
            try {
                Files.copy(tmp, (Path)dir, new CopyOption[0]);
                Assert.fail();
            }
            catch (FileAlreadyExistsException expected) {
                // empty catch block
            }
            try {
                Files.copy((Path)dir, tmp, new CopyOption[0]);
                Assert.fail();
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        finally {
            Files.delete(tmp);
        }
    }

    @Test
    public void testStrictFileOutputStream() throws IOException {
        TPath file = this.archive.resolve("test.txt");
        try (TConfig config = TConfig.open();){
            config.setLenient(false);
            try {
                this.assertFileOutputStream(file);
                Assert.fail((String)"Creating ghost directories should not be allowed when Path.isLenient() is false!");
            }
            catch (IOException expected) {
                // empty catch block
            }
            Files.createDirectory((Path)this.archive, new FileAttribute[0]);
            this.assertFileOutputStream(file);
            Files.delete((Path)this.archive);
        }
    }

    @Test
    public void testLenientFileOutputStream() throws IOException {
        TPath file = this.archive.resolve("dir/inner" + this.getExtension() + "/dir/test.txt");
        this.assertFileOutputStream(file);
        try {
            Files.delete((Path)this.archive);
            Assert.fail((String)"directory not empty");
        }
        catch (IOException expected) {
            // empty catch block
        }
        this.umount();
        Files.delete((Path)this.archive.toNonArchivePath());
        Assert.assertFalse((boolean)Files.exists((Path)this.archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)this.archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)this.archive, new LinkOption[0]));
        try {
            Files.size((Path)this.archive);
            Assert.fail();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private void assertFileOutputStream(TPath file) throws IOException {
        byte[] message = "Hello World!\r\n".getBytes();
        try (OutputStream out = Files.newOutputStream((Path)file, new OpenOption[0]);){
            Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
            Assert.assertEquals((long)0L, (long)Files.size((Path)file));
            out.write(message);
            Assert.assertEquals((long)0L, (long)Files.size((Path)file));
            out.flush();
            Assert.assertEquals((long)0L, (long)Files.size((Path)file));
        }
        Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        Assert.assertEquals((long)message.length, (long)Files.size((Path)file));
        try {
            Files.createFile((Path)file, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        Assert.assertTrue((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        Assert.assertEquals((long)message.length, (long)Files.size((Path)file));
        Files.delete((Path)file);
        Assert.assertFalse((boolean)Files.exists((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)file, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)file, new LinkOption[0]));
        try {
            Files.size((Path)file);
            Assert.fail();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    public void testBusyFileInputStream() throws IOException, InterruptedException {
        TPath file1 = this.archive.resolve("file1");
        TPath file2 = this.archive.resolve("file2");
        Files.createFile((Path)file1, new FileAttribute[0]);
        this.umount();
        Files.createFile((Path)file2, new FileAttribute[0]);
        try (InputStream in1 = Files.newInputStream((Path)file1, new OpenOption[0]);){
            block17: {
                block16: {
                    block15: {
                        try {
                            Files.copy(in1, (Path)file2, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (FsSyncException ex) {
                            if (ex.getCause() instanceof FsOpenResourceException) break block15;
                            throw ex;
                        }
                    }
                    try {
                        this.umount();
                        Assert.fail();
                    }
                    catch (FsSyncWarningException ex) {
                        if (ex.getCause() instanceof FsOpenResourceException) break block16;
                        throw ex;
                    }
                }
                Assert.assertTrue((boolean)Files.isRegularFile((Path)file2, new LinkOption[0]));
                try {
                    Files.copy(in1, (Path)file2, StandardCopyOption.REPLACE_EXISTING);
                    Assert.fail();
                }
                catch (ClosedInputException ex) {
                    // empty catch block
                }
                Files.newInputStream((Path)file1, new OpenOption[0]);
                try {
                    this.umount();
                }
                catch (FsSyncWarningException ex) {
                    if (ex.getCause() instanceof FsOpenResourceException) break block17;
                    throw ex;
                }
            }
            this.umount();
            Files.delete((Path)this.archive.toNonArchivePath());
        }
        try {
            Files.delete((Path)file2);
            Assert.fail();
        }
        catch (IOException alreadyDeletedExternally) {
            // empty catch block
        }
        Assert.assertFalse((boolean)Files.exists((Path)file2, new LinkOption[0]));
        try {
            Files.delete((Path)file1);
            Assert.fail();
        }
        catch (IOException alreadyDeletedExternally) {
            // empty catch block
        }
        Assert.assertFalse((boolean)Files.exists((Path)file1, new LinkOption[0]));
    }

    @Test
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    public void testBusyFileOutputStream() throws IOException, InterruptedException {
        TPath file2;
        TPath file1;
        block39: {
            OutputStream out;
            block38: {
                block37: {
                    file1 = this.archive.resolve("file1");
                    file2 = this.archive.resolve("file2");
                    out = Files.newOutputStream((Path)file1, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        Streams.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                    out = Files.newOutputStream((Path)file2, new OpenOption[0]);
                    throwable = null;
                    try {
                        Streams.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                    this.umount();
                    out = Files.newOutputStream((Path)file1, new OpenOption[0]);
                    Streams.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                    try {
                        Files.newOutputStream((Path)file1, new OpenOption[0]).close();
                        Assert.fail();
                    }
                    catch (FsSyncException ex) {
                        if (ex.getCause() instanceof FsOpenResourceException) break block37;
                        throw ex;
                    }
                }
                try {
                    Files.newOutputStream((Path)file2, new OpenOption[0]).close();
                }
                catch (FsSyncException ex) {
                    if (!(ex.getCause() instanceof FsOpenResourceException)) {
                        throw ex;
                    }
                    logger.info(this.getArchiveDriver().getClass() + " does not support concurrent writing of different entries in the same archive file.", (Throwable)ex);
                }
                Streams.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                try {
                    this.umount();
                    Assert.fail();
                }
                catch (FsSyncWarningException ex) {
                    if (ex.getCause() instanceof FsOpenResourceException) break block38;
                    throw ex;
                }
            }
            try {
                Streams.cat((InputStream)new ByteArrayInputStream(this.getData()), (OutputStream)out);
                Assert.fail();
            }
            catch (ClosedOutputException ex) {
                // empty catch block
            }
            out.close();
            Files.newOutputStream((Path)file1, new OpenOption[0]);
            out = null;
            try {
                this.umount();
            }
            catch (FsSyncWarningException ex) {
                if (ex.getCause() instanceof FsOpenResourceException) break block39;
                throw ex;
            }
        }
        this.umount();
        Files.delete((Path)file2);
        Assert.assertFalse((boolean)Files.exists((Path)file2, new LinkOption[0]));
        Files.delete((Path)file1);
        Assert.assertFalse((boolean)Files.exists((Path)file1, new LinkOption[0]));
    }

    @Test
    public void testMkdir() throws IOException {
        TPath dir1 = this.archive;
        TPath dir2 = dir1.resolve("dir");
        TPath dir3 = dir2.resolve("inner" + this.getExtension());
        TPath dir4 = dir3.resolve("dir");
        TPath dir5 = dir4.resolve("nuts" + this.getExtension());
        TPath dir6 = dir5.resolve("dir");
        assert (TConfig.current().isLenient());
        Files.createDirectory((Path)dir6, new FileAttribute[0]);
        try {
            Files.createDirectory((Path)dir6, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir5, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir4, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir3, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir2, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        try {
            Files.createDirectory((Path)dir1, new FileAttribute[0]);
            Assert.fail();
        }
        catch (FileAlreadyExistsException expected) {
            // empty catch block
        }
        Files.delete((Path)dir6);
        Files.delete((Path)dir5);
        Files.delete((Path)dir4);
        Files.delete((Path)dir3);
        Files.delete((Path)dir2);
        Files.delete((Path)dir1);
        try (TConfig config = TConfig.open();){
            config.setLenient(false);
            try {
                Files.createDirectory((Path)dir6, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir5, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir4, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir3, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            try {
                Files.createDirectory((Path)dir2, new FileAttribute[0]);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            Files.createDirectory((Path)dir1, new FileAttribute[0]);
            Files.createDirectory((Path)dir2, new FileAttribute[0]);
            Files.createDirectory((Path)dir3, new FileAttribute[0]);
            Files.createDirectory((Path)dir4, new FileAttribute[0]);
            Files.createDirectory((Path)dir5, new FileAttribute[0]);
            Files.createDirectory((Path)dir6, new FileAttribute[0]);
        }
        Files.delete((Path)dir6);
        Files.delete((Path)dir5);
        Files.delete((Path)dir4);
        Files.delete((Path)dir3);
        Files.delete((Path)dir2);
        Files.delete((Path)dir1);
    }

    @Test
    public void testDirectoryTree() throws IOException {
        this.assertDirectoryTree(new TPath(System.getProperty("java.io.tmpdir"), new String[0]), new TPath("dir/inner" + this.getExtension() + "/dir/outer" + this.getExtension() + "/" + this.archive.getFileName(), new String[0]));
    }

    private void assertDirectoryTree(TPath basePath, TPath reversePath) throws IOException {
        if (reversePath == null) {
            TPath test2 = basePath.resolve("test.txt");
            this.assertFileOutputStream(test2);
            return;
        }
        TPath member = basePath.resolve((Path)reversePath.getFileName());
        boolean created = false;
        try {
            Files.createDirectory((Path)member, new FileAttribute[0]);
            created = true;
        }
        catch (FileAlreadyExistsException ex) {
            // empty catch block
        }
        TPath children = reversePath.getParent();
        this.assertDirectoryTree(member, children);
        this.assertListFiles(basePath, member.getFileName().toString());
        Assert.assertTrue((boolean)Files.exists((Path)member, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isDirectory((Path)member, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)member, new LinkOption[0]));
        if (member.isArchive()) {
            Assert.assertEquals((long)0L, (long)Files.size((Path)member));
        }
        if (created) {
            Files.delete((Path)member);
            Assert.assertFalse((boolean)Files.exists((Path)member, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isDirectory((Path)member, new LinkOption[0]));
            Assert.assertFalse((boolean)Files.isRegularFile((Path)member, new LinkOption[0]));
            try {
                Files.size((Path)member);
                Assert.fail();
            }
            catch (NoSuchFileException expected) {
                // empty catch block
            }
        }
    }

    private void assertListFiles(TPath dir, String entry) throws IOException {
        Path[] files = TPathITSuite.listFiles((Path)dir);
        boolean found = false;
        for (Path file : files) {
            if (!file.getFileName().toString().equals(entry)) continue;
            found = true;
        }
        if (!found) {
            Assert.fail((String)("No such entry: " + entry));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path[] listFiles(Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            LinkedList<Path> list = new LinkedList<Path>();
            for (Path path : stream) {
                list.add(path);
            }
            Path[] pathArray = list.toArray(new Path[list.size()]);
            return pathArray;
        }
        catch (NotDirectoryException ex) {
            return null;
        }
    }

    @Test
    public void testInputOutput() throws IOException {
        this.assertInputOutput(this.archive);
        TPath archiveTest = this.archive.resolve("test");
        this.assertInputOutput(archiveTest);
        TPath archiveInner = this.archive.resolve("inner" + this.getExtension());
        TPath archiveInnerTest = archiveInner.resolve("test");
        this.assertInputOutput(archiveInnerTest);
        Files.delete((Path)archiveInner);
        Files.delete((Path)this.archive);
    }

    private void assertInputOutput(TPath file) throws IOException {
        this.assertInput(file);
        this.assertOutput(file);
        Files.delete((Path)file);
    }

    private void assertInput(TPath file) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.getData());){
            Files.copy(in, (Path)file, new CopyOption[0]);
        }
        Assert.assertEquals((long)this.getDataLength(), (long)Files.size((Path)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOutput(TPath file) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());){
            Files.copy((Path)file, out);
        }
        Assert.assertArrayEquals((byte[])this.getData(), (byte[])out.toByteArray());
    }

    @Test
    public void testCopyContainingOrSameFiles() throws IOException {
        assert (!Files.exists((Path)this.archive, new LinkOption[0]));
        TPath dir = this.archive.getParent();
        Assert.assertNotNull((Object)dir);
        TPath entry = this.archive.resolve("entry");
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        Files.copy(new ByteArrayInputStream(this.getData()), (Path)entry, new CopyOption[0]);
        this.assertCopyContainingOrSameFiles0(dir, this.archive);
        this.assertCopyContainingOrSameFiles0(this.archive, entry);
        this.archive.toFile().rm_r();
    }

    private void assertCopyContainingOrSameFiles0(TPath a, TPath b) throws IOException {
        this.assertCopyContainingOrSameFiles1(a, b);
        this.assertCopyContainingOrSameFiles1(a.toRealPath(new LinkOption[0]), b);
        this.assertCopyContainingOrSameFiles1(a, b.toRealPath(new LinkOption[0]));
        this.assertCopyContainingOrSameFiles1(a.toRealPath(new LinkOption[0]), b.toRealPath(new LinkOption[0]));
    }

    private void assertCopyContainingOrSameFiles1(TPath a, TPath b) throws IOException {
        try {
            Files.copy((Path)a, (Path)a, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Files.copy((Path)a, (Path)b, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Files.copy((Path)b, (Path)a, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            Files.copy((Path)b, (Path)b, StandardCopyOption.REPLACE_EXISTING);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCopyDelete() throws IOException {
        String[] names = new String[]{"0" + this.getExtension(), "1" + this.getExtension()};
        Files.createDirectory((Path)this.archive, new FileAttribute[0]);
        this.assertCopyDelete(this.archive, names, 0);
        Files.delete((Path)this.archive);
        Files.createDirectory((Path)this.archive.toNonArchivePath(), new FileAttribute[0]);
        this.assertCopyDelete(this.archive, names, 0);
        Files.delete((Path)this.archive);
    }

    private void assertCopyDelete(TPath parent, String[] names, int off) throws IOException {
        if (off >= names.length) {
            return;
        }
        TPath dir = parent.resolve(names[off]);
        Files.createDirectory((Path)dir, new FileAttribute[0]);
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        Files.delete((Path)dir);
        Files.createDirectory((Path)dir.toNonArchivePath(), new FileAttribute[0]);
        this.assertCopyDelete(parent, dir);
        this.assertCopyDelete(dir, names, off + 1);
        Files.delete((Path)dir);
    }

    private void assertCopyDelete(TPath parent, TPath dir) throws IOException {
        TPath parentFile = parent.resolve("file");
        TPath parentArchive = parent.resolve("archive" + this.getExtension());
        TPath dirFile = dir.resolve("file");
        TPath dirArchive = dir.resolve("archive" + this.getExtension());
        this.assertCopyDelete0(dirFile, dirArchive);
        this.assertCopyDelete0(dirFile, parentFile);
        this.assertCopyDelete0(dirFile, parentArchive);
        this.assertCopyDelete0(parentFile, dirFile);
        this.assertCopyDelete0(parentFile, dirArchive);
        this.assertCopyDelete0(parentArchive, dirFile);
        this.assertCopyDelete0(parentArchive, dirArchive);
        this.assertCopyDelete0(dirArchive, dirFile);
        this.assertCopyDelete0(dirArchive, parentFile);
        this.assertCopyDelete0(dirArchive, parentArchive);
    }

    private void assertCopyDelete0(TPath a, TPath b) throws IOException {
        this.assertCopyDelete0(a, b, 4000L);
    }

    private void assertCopyDelete0(TPath a, TPath b, long granularity) throws IOException {
        long time = System.currentTimeMillis();
        this.createTestFile(a);
        Files.setLastModifiedTime((Path)a, FileTime.fromMillis(time - granularity));
        Files.copy((Path)a, (Path)b, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertThat((Object)Files.size((Path)b), (Matcher)CoreMatchers.is((Object)Files.size((Path)a)));
        Assert.assertThat((Object)Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis())));
        Files.copy((Path)a, (Path)b, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        Assert.assertThat((Object)Files.size((Path)b), (Matcher)CoreMatchers.is((Object)Files.size((Path)a)));
        long almd = Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() / granularity * granularity;
        long blmd = Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() / granularity * granularity;
        long almu = (Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        long blmu = (Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((String)("almd (" + almd + ") != blmd (" + blmd + ") && almu (" + almu + ") != blmu (" + blmu + ")"), (almd == blmd || almu == blmu ? 1 : 0) != 0);
        Files.copy((Path)b, (Path)a, StandardCopyOption.REPLACE_EXISTING);
        Assert.assertThat((Object)Files.size((Path)a), (Matcher)CoreMatchers.is((Object)Files.size((Path)b)));
        Assert.assertThat((Object)Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis())));
        Files.copy((Path)b, (Path)a, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        Assert.assertThat((Object)Files.size((Path)a), (Matcher)CoreMatchers.is((Object)Files.size((Path)b)));
        almd = Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() / granularity * granularity;
        blmd = Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() / granularity * granularity;
        almu = (Files.getLastModifiedTime((Path)a, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        blmu = (Files.getLastModifiedTime((Path)b, new LinkOption[0]).toMillis() + granularity - 1L) / granularity * granularity;
        Assert.assertTrue((String)("almd (" + almd + ") != blmd (" + blmd + ") && almu (" + almu + ") != blmu (" + blmu + ")"), (almd == blmd || almu == blmu ? 1 : 0) != 0);
        this.verifyTestFile(a);
        Files.delete((Path)a);
        Files.delete((Path)b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegalDeleteOfEntryWithOpenStream() throws IOException {
        Throwable throwable;
        TPath entry1 = this.archive.resolve("entry1");
        TPath entry2 = this.archive.resolve("entry2");
        try (OutputStream out1 = Files.newOutputStream((Path)entry1, new OpenOption[0]);){
            try {
                Files.delete((Path)entry1);
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            out1.write(this.getData());
            throwable = null;
            try (OutputStream out2 = Files.newOutputStream((Path)entry2, new OpenOption[0]);){
                try {
                    Files.delete((Path)entry2);
                    Assert.fail();
                }
                catch (IOException expected) {
                    // empty catch block
                }
                out2.write(this.getData());
                try {
                    this.archive.toFile().rm_r();
                    Assert.fail();
                }
                catch (IOException expected) {
                    // empty catch block
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        var4_4 = null;
        try (InputStream in1 = Files.newInputStream((Path)entry1, new OpenOption[0]);){
            throwable = null;
            try (InputStream in2 = Files.newInputStream((Path)entry2, new OpenOption[0]);){
                Files.delete((Path)entry2);
                try (ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());){
                    Streams.cat((InputStream)in2, (OutputStream)out);
                }
                Assert.assertTrue((boolean)Arrays.equals(this.getData(), out.toByteArray()));
                try {
                    this.archive.toFile().rm_r();
                    Assert.fail();
                }
                catch (IOException expected) {
                    // empty catch block
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            try {
                Files.delete((Path)entry1);
                Assert.fail((String)"deleted within archive.toFile().rm_r()");
            }
            catch (IOException expected) {
                // empty catch block
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());){
                Streams.cat((InputStream)in1, (OutputStream)out);
            }
            Assert.assertTrue((boolean)Arrays.equals(this.getData(), out.toByteArray()));
            try {
                this.archive.toFile().rm_r();
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
        }
        catch (Throwable throwable3) {
            var4_4 = throwable3;
            throw throwable3;
        }
        this.archive.toFile().rm_r();
        Assert.assertFalse((boolean)Files.exists((Path)this.archive.toNonArchivePath(), new LinkOption[0]));
    }

    @Test
    public void testRenameValidArchive() throws IOException {
        try (PrintStream out = new PrintStream(Files.newOutputStream((Path)this.archive.resolve("entry"), new OpenOption[0]));){
            out.println("Hello World!");
        }
        this.assertRenameArchiveToTemp(this.archive);
    }

    @Test
    public void testRenameFalsePositive() throws IOException {
        TPath tmp = this.archive.toNonArchivePath();
        ByteArrayInputStream in = new ByteArrayInputStream(this.getData());
        Files.copy(in, (Path)tmp, new CopyOption[0]);
        this.assertRenameArchiveToTemp(this.archive);
    }

    private void assertRenameArchiveToTemp(TPath archive) throws IOException {
        assert (archive.isArchive());
        assert (!archive.isEntry());
        TPath tmp = new TPath(Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]));
        Files.delete((Path)tmp);
        Assert.assertFalse((boolean)Files.exists((Path)tmp, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)tmp.toNonArchivePath(), new LinkOption[0]));
        archive.toFile().mv((File)tmp.toFile());
        Assert.assertFalse((boolean)Files.exists((Path)archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)archive.toNonArchivePath(), new LinkOption[0]));
        tmp.toFile().rm_r();
        Assert.assertFalse((boolean)Files.exists((Path)tmp, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)tmp.toNonArchivePath(), new LinkOption[0]));
    }

    @Test
    public void testRenameRecursively() throws IOException {
        TPath temp = new TPath(this.createTempFile());
        TPath archive2 = this.archive.resolve("inner" + this.getExtension());
        TPath archive3 = archive2.resolve("nuts" + this.getExtension());
        TPath archive1a = this.archive.resolve("a");
        TPath archive1b = this.archive.resolve("b");
        TPath archive2a = archive2.resolve("a");
        TPath archive2b = archive2.resolve("b");
        TPath archive3a = archive3.resolve("a");
        TPath archive3b = archive3.resolve("b");
        Files.delete((Path)temp);
        this.assertInput(archive1a);
        for (int i = 2; i >= 1; --i) {
            this.assertRenameTo(archive1a, archive1b);
            this.assertRenameTo(archive1b, archive2a);
            this.assertRenameTo(archive2a, archive2b);
            this.assertRenameTo(archive2b, archive3a);
            this.assertRenameTo(archive3a, archive3b);
            this.assertRenameTo(archive3b, archive3a);
            this.assertRenameTo(archive3a, archive2b);
            this.assertRenameTo(archive2b, archive2a);
            this.assertRenameTo(archive2a, archive1b);
            this.assertRenameTo(archive1b, archive1a);
        }
        this.assertRenameTo(this.archive, temp);
        this.assertRenameTo(temp, this.archive);
        Files.delete((Path)archive3);
        Files.delete((Path)archive2);
        this.verifyTestFile(archive1a);
        Files.delete((Path)archive1a);
        Files.delete((Path)this.archive);
    }

    private void assertRenameTo(TPath src, TPath dst) throws IOException {
        Assert.assertTrue((boolean)Files.exists((Path)src, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)dst, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)dst.toNonArchivePath(), new LinkOption[0]));
        assert (TConfig.current().isLenient());
        src.toFile().mv((File)dst.toFile());
        Assert.assertFalse((boolean)Files.exists((Path)src, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.exists((Path)src.toNonArchivePath(), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists((Path)dst, new LinkOption[0]));
    }

    @Test
    public void testList() throws IOException {
        Path dir = this.createTempFile();
        TPath tdir = new TPath(dir);
        Assert.assertNull((Object)TPathITSuite.listFiles(dir));
        Assert.assertNull((Object)TPathITSuite.listFiles((Path)tdir));
        Assert.assertNull((Object)TPathITSuite.listFiles((Path)tdir.toNonArchivePath()));
        Files.delete(dir);
        Files.createDirectory(dir, new FileAttribute[0]);
        int i = MEMBERS.length;
        while (--i >= 0) {
            Files.createFile(dir.resolve(MEMBERS[i]), new FileAttribute[0]);
        }
        Object[] files = TPathITSuite.listFiles(dir);
        Arrays.sort(files);
        this.assertList((Path[])files, tdir);
        tdir.toFile().rm_r();
        Files.createDirectory((Path)tdir, new FileAttribute[0]);
        int i2 = MEMBERS.length;
        while (--i2 >= 0) {
            Files.createFile((Path)tdir.resolve(MEMBERS[i2]), new FileAttribute[0]);
        }
        this.assertList((Path[])files, tdir);
        tdir.toFile().rm_r();
    }

    private void assertList(Path[] expected, TPath dir) throws IOException {
        Object[] got = TPathITSuite.listFiles((Path)dir);
        Arrays.sort(got);
        Assert.assertEquals((long)expected.length, (long)got.length);
        int l = expected.length;
        for (int i = 0; i < l; ++i) {
            Path path = expected[i];
            TPath tpath = (TPath)got[i];
            Assert.assertTrue((!(path instanceof TPath) ? 1 : 0) != 0);
            Assert.assertEquals((Object)path.toString(), (Object)tpath.toString());
            Assert.assertNull((Object)TPathITSuite.listFiles((Path)tpath));
        }
    }

    @Test
    public void testMultithreadedSingleArchiveMultipleEntriesReading() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesReading(ConcurrencyUtils.NUM_IO_THREADS, ConcurrencyUtils.NUM_IO_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertMultithreadedSingleArchiveMultipleEntriesReading(final int nEntries, int nThreads) throws Exception {
        this.createTestArchive(nEntries);
        try {
            class CheckAllEntriesFactory
            implements ConcurrencyUtils.TaskFactory {
                CheckAllEntriesFactory() {
                }

                public Callable<?> newTask(int threadNum) {
                    class CheckAllEntries
                    implements Callable<Void> {
                        final /* synthetic */ int val$nEntries;

                        CheckAllEntries() {
                            this.val$nEntries = n;
                        }

                        @Override
                        public Void call() throws IOException {
                            TPathITSuite.this.assertArchiveEntries(TPathITSuite.this.archive, this.val$nEntries);
                            return null;
                        }
                    }
                    return new CheckAllEntries(TPathITSuite.this, nEntries);
                }
            }
            ConcurrencyUtils.start((int)nThreads, (ConcurrencyUtils.TaskFactory)new CheckAllEntriesFactory()).join();
        }
        finally {
            this.archive.toFile().rm_r();
        }
    }

    private void createTestArchive(int nEntries) throws IOException {
        for (int i = 0; i < nEntries; ++i) {
            this.createTestFile(new TPath(this.archive.toString(), new String[]{i + ""}));
        }
    }

    private void assertArchiveEntries(TPath archive, int nEntries) throws IOException {
        List<Path> entries = Arrays.asList(TPathITSuite.listFiles((Path)archive));
        assert (entries.size() == nEntries);
        Collections.shuffle(entries, new Random());
        byte[] buf = new byte[this.getDataLength()];
        for (Path _entry : entries) {
            TPath entry = (TPath)_entry;
            InputStream in = Files.newInputStream((Path)entry, new OpenOption[0]);
            Throwable throwable = null;
            try {
                int read;
                int off = 0;
                while (0 <= (read = in.read(buf))) {
                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    Assert.assertEquals((Object)ByteBuffer.wrap(this.getData(), off, read), (Object)ByteBuffer.wrap(buf, 0, read));
                    off += read;
                }
                Assert.assertEquals((long)-1L, (long)read);
                Assert.assertEquals((long)off, (long)this.getDataLength());
                Assert.assertTrue((0 >= in.read(new byte[0]) ? 1 : 0) != 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    @Test
    public void testMultithreadedSingleArchiveMultipleEntriesWriting() throws Exception {
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(false);
        this.assertMultithreadedSingleArchiveMultipleEntriesWriting(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertMultithreadedSingleArchiveMultipleEntriesWriting(final boolean wait) throws Exception {
        assert (TConfig.current().isLenient());
        try {
            class WriteFactory
            implements ConcurrencyUtils.TaskFactory {
                WriteFactory() {
                }

                public Callable<?> newTask(final int threadNum) {
                    class Write
                    implements Callable<Void> {
                        Write() {
                        }

                        @Override
                        public Void call() throws IOException {
                            block3: {
                                TPath entry = TPathITSuite.this.archive.resolve("" + threadNum);
                                TPathITSuite.this.createTestFile(entry);
                                try {
                                    TVFS.sync((FsMountPoint)TPathITSuite.this.archive.getNodePath().getMountPoint(), (BitField)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_IO, wait));
                                }
                                catch (FsSyncException ex) {
                                    if (!(ex.getCause() instanceof FsOpenResourceException)) {
                                        throw ex;
                                    }
                                    if (!wait) break block3;
                                    throw new AssertionError((Object)ex);
                                }
                            }
                            return null;
                        }
                    }
                    return new Write();
                }
            }
            ConcurrencyUtils.start((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new WriteFactory()).join();
        }
        finally {
            this.assertArchiveEntries(this.archive, ConcurrencyUtils.NUM_IO_THREADS);
            this.archive.toFile().rm_r();
        }
    }

    @Test
    public void testMultithreadedMultipleArchivesSingleEntryWriting() throws Exception {
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(false);
        this.assertMultithreadedMultipleArchivesSingleEntryWriting(true);
    }

    private void assertMultithreadedMultipleArchivesSingleEntryWriting(final boolean syncIndividually) throws Exception {
        assert (TConfig.current().isLenient());
        class WriteFactory
        implements ConcurrencyUtils.TaskFactory {
            WriteFactory() {
            }

            public Callable<?> newTask(int threadNum) {
                class Write
                implements Callable<Void> {
                    final /* synthetic */ boolean val$syncIndividually;

                    Write() {
                        this.val$syncIndividually = bl;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws IOException {
                        TPath archive = new TPath(TPathITSuite.this.createTempFile());
                        Files.delete((Path)archive);
                        TPath entry = archive.resolve("entry");
                        try {
                            TPathITSuite.this.createTestFile(entry);
                            try {
                                if (this.val$syncIndividually) {
                                    archive.getFileSystem().close();
                                } else {
                                    TVFS.sync((BitField)FsSyncOptions.SYNC);
                                }
                            }
                            catch (FsSyncWarningException ex) {
                                if (!(ex.getCause() instanceof FsOpenResourceException)) {
                                    throw ex;
                                }
                                if (this.val$syncIndividually) {
                                    throw new AssertionError((Object)ex);
                                }
                            }
                        }
                        finally {
                            archive.toFile().rm_r();
                        }
                        return null;
                    }
                }
                return new Write(TPathITSuite.this, syncIndividually);
            }
        }
        ConcurrencyUtils.start((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new WriteFactory()).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultithreadedMutualArchiveCopying() throws Exception {
        assert (TConfig.current().isLenient());
        TPath src = this.archive;
        try {
            TPath dst = new TPath(this.createTempFile());
            Files.delete((Path)dst);
            try {
                try {
                    class CopyFactory
                    implements ConcurrencyUtils.TaskFactory {
                        final TPath src;
                        final TPath dst;

                        CopyFactory(TPath src, TPath dst) {
                            this.src = src;
                            this.dst = dst;
                        }

                        public Callable<?> newTask(final int threadNum) {
                            class Copy
                            implements Callable<Void> {
                                Copy() {
                                }

                                @Override
                                public Void call() throws IOException {
                                    TPath srcNo = src.resolve("src/" + threadNum);
                                    TPath dstNo = dst.resolve("dst/" + threadNum);
                                    TPathITSuite.this.createTestFile(srcNo);
                                    Files.copy((Path)srcNo, (Path)dstNo, StandardCopyOption.REPLACE_EXISTING);
                                    return null;
                                }
                            }
                            return new Copy();
                        }
                    }
                    ConcurrencyUtils.TaskJoiner join = ConcurrencyUtils.start((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new CopyFactory(src, dst));
                    try {
                        ConcurrencyUtils.start((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new CopyFactory(dst, src)).join();
                    }
                    finally {
                        join.join();
                    }
                }
                finally {
                    dst.getFileSystem().close();
                }
            }
            finally {
                Files.delete((Path)dst.toNonArchivePath());
            }
        }
        finally {
            src.getFileSystem().close();
        }
    }

    @Test
    public void testGrowing() throws IOException {
        TPath path = this.archive.toNonArchivePath();
        TPath entry1 = this.archive.resolve("entry1");
        TPath entry2 = this.archive.resolve("entry2");
        try (TConfig config = TConfig.open();){
            config.setAccessPreference(FsAccessOption.GROW, true);
            this.createTestFile(entry1);
            this.createTestFile(entry2);
            this.umount();
            Assert.assertTrue((Files.size((Path)path) > (long)(2 * this.getDataLength()) ? 1 : 0) != 0);
            this.createTestFile(entry1);
            this.createTestFile(entry2);
            this.createTestFile(entry1);
            this.createTestFile(entry2);
            Files.delete((Path)entry1);
            Files.delete((Path)entry2);
            this.umount();
            Assert.assertTrue((Files.size((Path)path) > (long)(6 * this.getDataLength()) ? 1 : 0) != 0);
        }
        Assert.assertThat((Object)TPathITSuite.listFiles((Path)this.archive).length, (Matcher)CoreMatchers.is((Object)0));
        config = TConfig.open();
        var5_5 = null;
        try {
            config.setAccessPreference(FsAccessOption.GROW, true);
            Files.delete((Path)this.archive);
            this.umount();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (config != null) {
                if (var5_5 != null) {
                    try {
                        config.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    config.close();
                }
            }
        }
        Assert.assertNull((Object)TPathITSuite.listFiles((Path)this.archive));
    }

    private static interface Factory<O, P, E extends Exception> {
        public O create(P var1) throws E;
    }
}

