/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.it;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.ConcurrencyUtils;
import net.java.truevfs.access.ConfiguredClientTestBase;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileOutputStream;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import org.junit.Assert;
import org.junit.Test;

public abstract class ConcurrentSyncITSuite<D extends FsArchiveDriver<?>>
extends ConfiguredClientTestBase<D> {
    private static final String TEMP_FILE_PREFIX = "tzp-sync";
    private static final int NUM_REPEATS = 10;

    @Test
    public void testConcurrentSync() throws Exception {
        Exception ex = null;
        class SyncFactory
        implements ConcurrencyUtils.TaskFactory {
            SyncFactory() {
            }

            public Callable<?> newTask(int threadNum) {
                class Sync
                implements Callable<Void> {
                    Sync() {
                    }

                    @Override
                    public Void call() throws IOException {
                        while (!Thread.interrupted()) {
                            TVFS.sync((BitField)FsSyncOptions.SYNC);
                        }
                        return null;
                    }
                }
                return new Sync();
            }
        }
        ConcurrencyUtils.TaskJoiner sync = ConcurrencyUtils.start((int)ConcurrencyUtils.NUM_CPU_THREADS, (ConcurrencyUtils.TaskFactory)new SyncFactory());
        try {
            class RoundTripFactory
            implements ConcurrencyUtils.TaskFactory {
                RoundTripFactory() {
                }

                public Callable<?> newTask(final int threadNum) {
                    class RoundTrip
                    implements Callable<Void> {
                        RoundTrip() {
                        }

                        @Override
                        public Void call() throws Exception {
                            for (int i = 0; i < 10; ++i) {
                                ConcurrentSyncITSuite.this.roundTrip(threadNum);
                            }
                            return null;
                        }
                    }
                    return new RoundTrip();
                }
            }
            ConcurrencyUtils.start((int)ConcurrencyUtils.NUM_IO_THREADS, (ConcurrencyUtils.TaskFactory)new RoundTripFactory()).join();
        }
        catch (InterruptedException | ExecutionException ex2) {
            ex = ex2;
            throw ex2;
        }
        finally {
            try {
                sync.cancel();
                sync.join();
            }
            catch (InterruptedException | ExecutionException ex2) {
                if (null == ex) {
                    throw ex2;
                }
                ex.addSuppressed(ex2);
            }
        }
    }

    void roundTrip(int i) throws IOException {
        TFile archive = this.newTempArchive();
        TFile file = new TFile((File)archive, i + this.getExtension() + "/" + i);
        this.roundTrip(file);
        archive.rm_r();
    }

    private TFile newTempArchive() throws IOException {
        File temp = File.createTempFile(TEMP_FILE_PREFIX, this.getExtension()).getCanonicalFile();
        TFile.rm((File)temp);
        return new TFile(temp);
    }

    private void roundTrip(TFile outer) throws IOException {
        TFile inner = new TFile((File)outer.getParentFile(), "inner" + this.getExtension() + "/" + outer.getName());
        this.create(inner);
        this.check(inner);
        inner.mv((File)outer);
        this.check(outer);
        outer.mv((File)inner);
        this.check(inner);
        inner.rm();
    }

    private void create(TFile file) throws IOException {
        try (TFileOutputStream out = new TFileOutputStream((File)file);){
            out.write(this.getData());
        }
        Assert.assertEquals((long)this.getDataLength(), (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(TFile file) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(this.getDataLength());){
            file.output((OutputStream)out);
        }
        Assert.assertTrue((boolean)Arrays.equals(this.getData(), out.toByteArray()));
    }
}

