/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import net.java.truecommons.shed.Paths;
import net.java.truevfs.access.MockArchiveDriverTestBase;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TPath;
import net.java.truevfs.kernel.spec.FsNodePath;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TPathTest
extends MockArchiveDriverTestBase {
    @Test
    public void testIllegalConstructorParametersOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (Object[] params : new Object[][]{{"c:", NO_STRINGS}, {"c:foo", NO_STRINGS}}) {
            try {
                new TPath(params[0].toString(), (String[])params[1]);
                Assert.fail();
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testStringConstructorOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (Object[] params : new Object[][]{{"c:/foo", NO_STRINGS, "c:/foo", "file:/c:/foo"}, {"//foo", new String[]{"bar", "baz"}, "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}, {"///foo//", new String[]{"//bar//", "//", "//baz//"}, "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}}) {
            TPathTest.assertConstructorWithStrings(params);
        }
    }

    @Test
    public void testStringConstructor() {
        for (Object[] params : new Object[][]{{"/", NO_STRINGS, "/", ROOT_DIRECTORY}, {"/s\u00f6me p\u00e4th with sp\u00e4ces", NO_STRINGS, "/s\u00f6me p\u00e4th with sp\u00e4ces", ROOT_DIRECTORY + "s\u00f6me%20p\u00e4th%20with%20sp\u00e4ces"}, {"/foo", NO_STRINGS, "/foo", ROOT_DIRECTORY + "foo"}, {"/foo", new String[]{""}, "/foo", ROOT_DIRECTORY + "foo"}, {"/foo", new String[]{"bar"}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo", new String[]{"/bar"}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo//", new String[]{"//", "//bar//", ""}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo", new String[]{""}, "/foo", ROOT_DIRECTORY + "foo"}, {"/foo", new String[]{".."}, "/foo/..", ROOT_DIRECTORY}, {"/foo", new String[]{"/bar"}, "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"/foo.mok", new String[]{"/bar"}, "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"/foo", new String[]{"/bar.mok"}, "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"/foo.mok", new String[]{"/bar.mok"}, "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"", new String[]{"/foo"}, "foo", CURRENT_DIRECTORY + "foo"}, {"", new String[]{"foo"}, "foo", CURRENT_DIRECTORY + "foo"}, {"", NO_STRINGS, "", CURRENT_DIRECTORY}, {".", NO_STRINGS, ".", CURRENT_DIRECTORY}, {"s\u00f6me p\u00e4th with sp\u00e4ces", NO_STRINGS, "s\u00f6me p\u00e4th with sp\u00e4ces", CURRENT_DIRECTORY + "s\u00f6me%20p\u00e4th%20with%20sp\u00e4ces"}, {"foo", NO_STRINGS, "foo", CURRENT_DIRECTORY + "foo"}, {"foo", new String[]{""}, "foo", CURRENT_DIRECTORY + "foo"}, {"foo", new String[]{".."}, "foo/..", CURRENT_DIRECTORY}, {"foo", new String[]{"bar"}, "foo/bar", CURRENT_DIRECTORY + "foo/bar"}, {"foo.mok", new String[]{"bar"}, "foo.mok/bar", "mok:" + CURRENT_DIRECTORY + "foo.mok!/bar"}, {"foo", new String[]{"bar.mok"}, "foo/bar.mok", "mok:" + CURRENT_DIRECTORY + "foo/bar.mok!/"}, {"foo.mok", new String[]{"bar.mok"}, "foo.mok/bar.mok", "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/bar.mok!/"}}) {
            TPathTest.assertConstructorWithStrings(params);
        }
    }

    private static void assertConstructorWithStrings(Object ... params) {
        String first = params[0].toString();
        String[] more = (String[])params[1];
        String name = params[2].toString();
        FsNodePath nodePath = FsNodePath.create((URI)URI.create(params[3].toString()));
        TPath path = new TPath(first, more);
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)name.replace("/", path.getFileSystem().getSeparator())));
        Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)nodePath.getMountPoint()));
        Assert.assertThat((Object)path.getNodeName(), (Matcher)CoreMatchers.equalTo((Object)nodePath.getNodeName()));
    }

    @Test
    public void testUriConstructor() {
        for (Object[] params : new Object[][]{{"", "file", true}, {"/", "file", true}, {"file:/", "file", true}, {"foo:/", "foo", false}}) {
            URI uri = URI.create(params[0].toString());
            String scheme = params[1].toString();
            boolean succeeds = (Boolean)params[2];
            TPath path = new TPath(uri);
            URI result = path.getUri();
            Assert.assertThat((Object)result.getScheme(), (Matcher)CoreMatchers.is((Object)scheme));
            assert (!result.isOpaque());
            try {
                Assert.assertThat((Object)path.getFileSystem().provider().getScheme(), (Matcher)CoreMatchers.is((Object)scheme));
                if (succeeds) continue;
                Assert.fail();
            }
            catch (ServiceConfigurationError ex) {
                if (!succeeds) continue;
                throw ex;
            }
        }
    }

    @Test
    public void testResolveOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (Object[] params : new Object[][]{{"x", "c:/foo", "c:/foo", ROOT_DIRECTORY + "c:/foo"}, {"x", "//foo/bar/baz", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}, {"x", "///foo//bar//baz//", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}}) {
            TPathTest.assertResolve(params);
        }
    }

    @Test
    public void testResolve() {
        for (Object[] params : new Object[][]{{"", "/", "/", ROOT_DIRECTORY}, {"x", "/foo", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/bar", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo//bar//", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo/..", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo/../", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo.mok/bar", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo.mok/bar/", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo/bar.mok", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo/bar.mok/", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo.mok/bar.mok", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"x", "/foo.mok/bar.mok/", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"/", "", "/", ROOT_DIRECTORY}, {"/", "foo", "/foo", ROOT_DIRECTORY + "foo"}, {"/", "foo/", "/foo", ROOT_DIRECTORY + "foo"}, {"/", ".", "/", ROOT_DIRECTORY}, {"/", "./", "/", ROOT_DIRECTORY}, {"", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {".", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar", "foo/bar", CURRENT_DIRECTORY + "foo/bar"}, {"foo", "bar/", "foo/bar", CURRENT_DIRECTORY + "foo/bar"}, {"", "bar/..", "bar/..", CURRENT_DIRECTORY}, {"", "bar/../", "bar/..", CURRENT_DIRECTORY}, {"foo.mok", "bar", "foo.mok/bar", "mok:" + CURRENT_DIRECTORY + "foo.mok!/bar"}, {"foo.mok", "bar/", "foo.mok/bar", "mok:" + CURRENT_DIRECTORY + "foo.mok!/bar"}, {"foo", "bar.mok", "foo/bar.mok", "mok:" + CURRENT_DIRECTORY + "foo/bar.mok!/"}, {"foo", "bar.mok/", "foo/bar.mok", "mok:" + CURRENT_DIRECTORY + "foo/bar.mok!/"}, {"foo.mok", "bar.mok", "foo.mok/bar.mok", "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"foo.mok", "bar.mok/", "foo.mok/bar.mok", "mok:mok:" + CURRENT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"foo.mok", "..", "", CURRENT_DIRECTORY}, {"foo.mok", "../", "", CURRENT_DIRECTORY}, {"foo.mok", "../bar.mok", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "../bar.mok/", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}}) {
            TPathTest.assertResolve(params);
        }
    }

    private static void assertResolve(Object ... params) {
        TPath parent = new TPath(params[0].toString(), new String[0]);
        String first = params[1].toString();
        String name = params[2].toString();
        FsNodePath nodePath = FsNodePath.create((URI)URI.create(params[3].toString()));
        TPath member = new TPath(first, new String[0]);
        TPath path = parent.resolve((Path)member);
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)name.replace("/", path.getFileSystem().getSeparator())));
        Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)nodePath.getMountPoint()));
        Assert.assertThat((Object)path.getNodeName(), (Matcher)CoreMatchers.equalTo((Object)nodePath.getNodeName()));
    }

    @Test
    public void testResolveSiblingOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (Object[] params : new Object[][]{{"x", "c:/foo", "c:/foo", ROOT_DIRECTORY + "c:/foo"}, {"x", "//foo/bar/baz", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}, {"x", "///foo//bar//baz//", "//foo/bar/baz", ROOT_DIRECTORY + "/foo/bar/baz"}}) {
            TPathTest.assertResolveSibling(params);
        }
    }

    @Test
    public void testResolveSibling() {
        for (Object[] params : new Object[][]{{"", "/", "/", ROOT_DIRECTORY}, {"x", "/foo", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/", "/foo", ROOT_DIRECTORY + "foo"}, {"x", "/foo/bar", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo//bar//", "/foo/bar", ROOT_DIRECTORY + "foo/bar"}, {"x", "/foo/..", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo/../", "/foo/..", ROOT_DIRECTORY}, {"x", "/foo.mok/bar", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo.mok/bar/", "/foo.mok/bar", "mok:" + ROOT_DIRECTORY + "foo.mok!/bar"}, {"x", "/foo/bar.mok", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo/bar.mok/", "/foo/bar.mok", "mok:" + ROOT_DIRECTORY + "foo/bar.mok!/"}, {"x", "/foo.mok/bar.mok", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"x", "/foo.mok/bar.mok/", "/foo.mok/bar.mok", "mok:mok:" + ROOT_DIRECTORY + "foo.mok!/bar.mok!/"}, {"/", "", "", CURRENT_DIRECTORY}, {"/", "foo", "foo", CURRENT_DIRECTORY + "foo"}, {"/", "foo/", "foo", CURRENT_DIRECTORY + "foo"}, {"/", ".", ".", CURRENT_DIRECTORY}, {"/", "./", ".", CURRENT_DIRECTORY}, {"", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {".", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"", "bar/..", "bar/..", CURRENT_DIRECTORY}, {"", "bar/../", "bar/..", CURRENT_DIRECTORY}, {"foo.mok", "bar", "bar", CURRENT_DIRECTORY + "bar"}, {"foo.mok", "bar/", "bar", CURRENT_DIRECTORY + "bar"}, {"foo", "bar.mok", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo", "bar.mok/", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "bar.mok", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "bar.mok/", "bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", ".", ".", CURRENT_DIRECTORY}, {"foo.mok", "./", ".", CURRENT_DIRECTORY}, {"foo.mok", "./bar.mok", "./bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}, {"foo.mok", "./bar.mok/", "./bar.mok", "mok:" + CURRENT_DIRECTORY + "bar.mok!/"}}) {
            TPathTest.assertResolveSibling(params);
        }
    }

    private static void assertResolveSibling(Object ... params) {
        TPath parent = new TPath(params[0].toString(), new String[0]);
        String first = params[1].toString();
        String name = params[2].toString();
        FsNodePath nodePath = FsNodePath.create((URI)URI.create(params[3].toString()));
        TPath member = new TPath(first, new String[0]);
        TPath path = parent.resolveSibling((Path)member);
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)name.replace("/", path.getFileSystem().getSeparator())));
        Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)nodePath.getMountPoint()));
        Assert.assertThat((Object)path.getNodeName(), (Matcher)CoreMatchers.equalTo((Object)nodePath.getNodeName()));
    }

    @Test
    public void testGetParentOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (String[] params : new String[][]{{"c:/", null}, {"c:/foo", "c:/"}, {"c:/foo/", "c:/"}}) {
            TPathTest.assertGetParent(params);
        }
    }

    @Test
    public void testGetParent() {
        for (String[] params : new String[][]{{"", null}, {".", null}, {"./", null}, {"..", null}, {"../", null}, {"foo", null}, {"foo/", null}, {"foo/.", "foo"}, {"foo/./", "foo"}, {"foo/..", "foo"}, {"foo/../", "foo"}, {"./foo", null}, {"./foo/", null}, {"../foo", ".."}, {"../foo/", ".."}, {"/", null}, {"/foo", "/"}, {"/foo/", "/"}, {"/foo/..", "/foo"}, {"/foo/../", "/foo"}}) {
            TPathTest.assertGetParent(params);
        }
    }

    private static void assertGetParent(String ... params) {
        TPath path = new TPath(params[0], new String[0]);
        TPath parent = null == params[1] ? null : new TPath(params[1], new String[0]);
        Assert.assertThat((Object)path.getParent(), (Matcher)CoreMatchers.is((Object)parent));
    }

    @Test
    public void testGetRootOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (String[] params : new String[][]{{"c://", "c:/"}, {"c:/", "c://"}, {"c:/foo", "c:/"}, {"//foo/bar/", "//foo/bar/"}, {"//foo/bar/baz", "//foo/bar/"}}) {
            TPathTest.assertGetRoot(params);
        }
    }

    @Test
    public void testGetRoot() {
        for (String[] params : new String[][]{{"", null}, {"foo", null}, {"/", "/"}, {"/foo", "/"}}) {
            TPathTest.assertGetRoot(params);
        }
    }

    private static void assertGetRoot(String ... params) {
        String test2 = params[0];
        String root = params[1];
        TPath testPath = new TPath(test2, new String[0]);
        TPath rootPath = root == null ? null : new TPath(root, new String[0]);
        Assert.assertThat((Object)testPath.getRoot(), (Matcher)CoreMatchers.is((Object)rootPath));
    }

    @Test
    public void testGetFileNameOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (String[] params : new String[][]{{"c:/", null}, {"c:/foo", "foo"}, {"c:/foo/bar", "bar"}, {"//foo/bar/", null}, {"//foo/bar/baz", "baz"}}) {
            TPathTest.assertGetFileName(params);
        }
    }

    @Test
    public void testGetFileName() {
        for (String[] params : new String[][]{{"", null}, {"foo", "foo"}, {"foo/bar", "bar"}, {"/", null}, {"/foo", "foo"}, {"/foo/bar", "bar"}}) {
            TPathTest.assertGetFileName(params);
        }
    }

    private static void assertGetFileName(String ... params) {
        String test2 = params[0];
        String fileName = params[1];
        TPath testPath = new TPath(test2, new String[0]);
        TPath fileNamePath = fileName == null ? null : new TPath(fileName, new String[0]);
        Assert.assertThat((Object)testPath.getFileName(), (Matcher)CoreMatchers.is((Object)fileNamePath));
    }

    @Test
    public void testCutTrailingSeparators() {
        Assert.assertThat((Object)TPath.cutTrailingSeparators((String)"c://", (int)3), (Matcher)CoreMatchers.is((Object)"c:/"));
        Assert.assertThat((Object)TPath.cutTrailingSeparators((String)"///", (int)2), (Matcher)CoreMatchers.is((Object)"//"));
        Assert.assertThat((Object)TPath.cutTrailingSeparators((String)"//", (int)1), (Matcher)CoreMatchers.is((Object)"/"));
    }

    @Test
    public void testElementsOnWindows() {
        if ('\\' != File.separatorChar) {
            return;
        }
        for (Object[] params : new Object[][]{{"c:/foo", NO_STRINGS}, {"c:/foo", new String[]{"bar"}}, {"//foo/bar/boom", NO_STRINGS}, {"//foo/bar/boom", new String[]{"bang"}}}) {
            TPathTest.assertElements(params);
        }
    }

    @Test
    public void testElements() {
        for (Object[] params : new Object[][]{{"", null}, {"foo", NO_STRINGS}, {"foo", new String[]{"bar"}}, {"/", null}, {"/foo", NO_STRINGS}, {"/foo", new String[]{"bar"}}}) {
            TPathTest.assertElements(params);
        }
    }

    private static void assertElements(Object ... params) {
        int count;
        TPath path;
        String first = params[0].toString();
        String[] more = (String[])params[1];
        if (null == more) {
            path = new TPath(first, new String[0]);
            count = 0;
        } else {
            path = new TPath(first, more);
            count = more.length + 1;
        }
        Assert.assertThat((Object)path.getNameCount(), (Matcher)CoreMatchers.is((Object)count));
        Iterator it = path.iterator();
        if (0 < count--) {
            Assert.assertThat((Object)path.getName(0).toString(), (Matcher)CoreMatchers.is((Object)TPathTest.stripPrefix(first)));
            Assert.assertThat((Object)((Path)it.next()).toString(), (Matcher)CoreMatchers.is((Object)TPathTest.stripPrefix(first)));
            int i = 0;
            while (i < count) {
                String m = more[i];
                String p = path.getName(++i).toString();
                Assert.assertThat((Object)p, (Matcher)CoreMatchers.is((Object)m));
                Assert.assertThat((Object)((Path)it.next()).toString(), (Matcher)CoreMatchers.is((Object)m));
            }
        }
        Assert.assertThat((Object)it.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static String stripPrefix(String s) {
        return s.substring(Paths.prefixLength((String)s, (char)'/', (boolean)true));
    }

    @Test
    public void testConfiguration() {
        TPath file;
        TPath directory = new TPath("", new String[0]);
        TPath archive = directory.resolve("archive.mok");
        try (TConfig config = TConfig.open();){
            config.setArchiveDetector(TArchiveDetector.NULL);
            file = directory.resolve("archive.mok");
        }
        assert (archive.getArchiveDetector() == this.getConfig().getArchiveDetector());
        assert (archive.isArchive());
        assert (file.getArchiveDetector() == TArchiveDetector.NULL);
        assert (!file.isArchive());
    }
}

