/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ServiceConfigurationError;
import net.java.truevfs.access.MockArchiveDriverTestBase;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TFileTest
extends MockArchiveDriverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(TFileTest.class);
    private TFile archive;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        this.archive = new TFile("archive" + this.getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        try {
            assert (!new File("archive" + this.getExtension()).exists());
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testFileExtension() {
        assert (!new TFile("test.file").isArchive());
    }

    @Test
    public void testPathConstructor() {
        for (String[] params : new String[][]{{"mok2:mok1:file:/foo.mok1!/bar.mok2!/META-INF/MANIFEST.MF", "/foo.mok1/bar.mok2/META-INF/MANIFEST.MF", "/foo.mok1/bar.mok2", "/foo.mok1/bar.mok2", "META-INF/MANIFEST.MF"}, {"mok2:mok1:file:/foo.mok1!/bar.mok2!/", "/foo.mok1/bar.mok2", "/foo.mok1/bar.mok2", "/foo.mok1", "bar.mok2"}, {"mok1:file:/foo.mok1!/META-INF/MANIFEST.MF", "/foo.mok1/META-INF/MANIFEST.MF", "/foo.mok1", "/foo.mok1", "META-INF/MANIFEST.MF"}, {"mok1:file:/foo.mok1!/", "/foo.mok1", "/foo.mok1", null, null}, {"mok2:file:/foo.mok2!/META-INF/MANIFEST.MF", "/foo.mok2/META-INF/MANIFEST.MF", "/foo.mok2", "/foo.mok2", "META-INF/MANIFEST.MF"}, {"mok2:file:/foo.mok2!/", "/foo.mok2", "/foo.mok2", null, null}, {"file:/foo", "/foo", null, null, null}, {"file:/", "/", null, null, null}}) {
            TFileTest.assertPathConstructor(new TFile(FsNodePath.create((URI)URI.create(params[0]))), params);
        }
    }

    private static void assertPathConstructor(TFile file, String[] params) {
        Assert.assertThat((Object)file.getArchiveDetector(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)TConfig.current().getArchiveDetector())));
        Assert.assertThat((Object)file.getPath(), (Matcher)CoreMatchers.equalTo((Object)params[1].replace('/', File.separatorChar)));
        if (null != params[2]) {
            Assert.assertThat((Object)file.getInnerArchive().getPath(), (Matcher)CoreMatchers.equalTo((Object)params[2].replace('/', File.separatorChar)));
        } else {
            Assert.assertThat((Object)file.getInnerArchive(), (Matcher)CoreMatchers.nullValue());
        }
        if (null != params[3]) {
            Assert.assertThat((Object)file.getEnclArchive().getPath(), (Matcher)CoreMatchers.equalTo((Object)params[3].replace('/', File.separatorChar)));
            Assert.assertThat((Object)file.getEnclEntryName(), (Matcher)CoreMatchers.equalTo((Object)params[4]));
        } else {
            Assert.assertThat((Object)file.getEnclArchive(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)file.getEnclEntryName(), (Matcher)CoreMatchers.nullValue());
        }
        Assert.assertThat((Object)new TFile(file.getNodePath()), (Matcher)CoreMatchers.equalTo((Object)file.getNormalizedAbsoluteFile()));
        Assert.assertThat((Object)new TFile(file.getUri()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
    }

    @Test
    public void testUriConstructor() throws Exception {
        String fs = File.separator;
        TFile file = new TFile(new URI("file", "/with a space", null));
        Assert.assertEquals((Object)"with a space", (Object)file.getName());
        Assert.assertNull((Object)file.getInnerArchive());
        Assert.assertNull((Object)file.getInnerEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("file", "/a .mok/b .mok/", null));
        Assert.assertNull((Object)file.getInnerArchive());
        Assert.assertNull((Object)file.getInnerEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("file", "/a .mok/b .mok", null));
        Assert.assertNull((Object)file.getInnerArchive());
        Assert.assertNull((Object)file.getInnerEntryName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("mok", "file:/a .mok/b .mok!/", null));
        Assert.assertSame((Object)file, (Object)file.getInnerArchive());
        Assert.assertSame((Object)FsNodeName.ROOT, (Object)file.getNodeName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        file = new TFile(new URI("mok", "file:/a .mok!/b .mok", null));
        Assert.assertSame((Object)file.getInnerArchive(), (Object)file.getEnclArchive());
        Assert.assertSame((Object)file.getInnerEntryName(), (Object)file.getEnclEntryName());
        Assert.assertEquals((Object)(fs + "a .mok"), (Object)file.getEnclArchive().getPath());
        Assert.assertEquals((Object)"b .mok", (Object)file.getEnclEntryName());
        try {
            new TFile(new URI("mok", "mok:file:/a .mok/b .mok!/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:file:/a .mok/b .mok!", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:file:/a .mok!/b .mok/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:file:/a .mok!/b .mok", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:mok:file:/a .mok/b .mok!/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:mok:file:/a .mok/b .mok!", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        file = new TFile(new URI("mok", "mok:file:/a .mok!/b .mok!/", null));
        Assert.assertSame((Object)file, (Object)file.getInnerArchive());
        Assert.assertSame((Object)FsNodeName.ROOT, (Object)file.getNodeName());
        Assert.assertEquals((Object)(fs + "a .mok"), (Object)file.getEnclArchive().getPath());
        Assert.assertEquals((Object)"b .mok", (Object)file.getEnclEntryName());
        file = new TFile(new URI("mok", "file:/a .mok!/b .mok!/", null));
        Assert.assertSame((Object)file, (Object)file.getInnerArchive());
        Assert.assertSame((Object)FsNodeName.ROOT, (Object)file.getNodeName());
        Assert.assertNull((Object)file.getEnclArchive());
        Assert.assertNull((Object)file.getEnclEntryName());
        try {
            new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok!/../c .mok!/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "mok:mok:file:/a .mok!/b .mok!/../c .mok!", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "file:/a .mok!/../b .mok/", null));
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new TFile(new URI("mok", "file:/a .mok!/../b .mok", null));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParentConstructor() throws Exception {
        TFile file;
        int i;
        try {
            new TFile("x", (String)null);
            Assert.fail((String)"Expected NullPointerException!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new TFile((File)new TFile("x"), (String)null);
            Assert.fail((String)"Expected NullPointerException!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        String fs = File.separator;
        TFile[] files = new TFile[]{new TFile((File)this.archive, ""), new TFile((File)this.archive, "."), new TFile((File)this.archive, "." + fs), new TFile((File)this.archive, "." + fs + "."), new TFile((File)this.archive, "." + fs + "." + fs), new TFile((File)this.archive, "." + fs + "." + fs + ".")};
        for (int i2 = 0; i2 < files.length; ++i2) {
            TFile file2 = files[i2];
            Assert.assertSame((Object)file2, (Object)file2.getInnerArchive());
            Assert.assertEquals((Object)"", (Object)file2.getInnerEntryName());
            Assert.assertNull((Object)file2.getEnclArchive());
            Assert.assertNull((Object)file2.getEnclEntryName());
        }
        String innerName = "inner.mok";
        TFile inner = new TFile((File)this.archive, "inner.mok");
        TFile[] files2 = new TFile[]{new TFile((File)inner, ""), new TFile((File)inner, "."), new TFile((File)inner, "." + fs), new TFile((File)inner, "." + fs + "."), new TFile((File)inner, "." + fs + "." + fs), new TFile((File)inner, "." + fs + "." + fs + ".")};
        for (i = 0; i < files2.length; ++i) {
            file = files2[i];
            Assert.assertSame((Object)file, (Object)file.getInnerArchive());
            Assert.assertEquals((Object)"", (Object)file.getInnerEntryName());
            Assert.assertSame((Object)this.archive, (Object)file.getEnclArchive());
            Assert.assertEquals((Object)"inner.mok", (Object)file.getEnclEntryName());
        }
        String entryName = "entry";
        TFile entry = new TFile((File)this.archive, "entry");
        files2 = new TFile[]{new TFile((File)entry, ""), new TFile((File)entry, "."), new TFile((File)entry, "." + fs), new TFile((File)entry, "." + fs + "."), new TFile((File)entry, "." + fs + "." + fs), new TFile((File)entry, "." + fs + "." + fs + ".")};
        for (i = 0; i < files2.length; ++i) {
            file = files2[i];
            Assert.assertSame((Object)this.archive, (Object)file.getInnerArchive());
            Assert.assertEquals((Object)"entry", (Object)file.getInnerEntryName());
            Assert.assertSame((Object)this.archive, (Object)file.getEnclArchive());
            Assert.assertEquals((Object)"entry", (Object)file.getEnclEntryName());
        }
        TFile a = new TFile("outer.mok/removed.mok");
        TFile b = new TFile("../removed.dir/removed.dir/../../dir/./inner.mok");
        TFile c = new TFile((File)a, b.getPath());
        Assert.assertTrue((boolean)c.isArchive());
        Assert.assertTrue((boolean)c.isEntry());
        Assert.assertEquals((Object)"outer.mok", (Object)c.getEnclArchive().getPath());
        Assert.assertEquals((Object)"dir/inner.mok", (Object)c.getEnclEntryName());
        b = new TFile("../removed.dir/removed.dir/../../dir/./inner.mok");
        c = new TFile((File)a, b.getPath(), TArchiveDetector.NULL);
        Assert.assertFalse((boolean)c.isArchive());
        Assert.assertTrue((boolean)c.isEntry());
        Assert.assertEquals((Object)"outer.mok", (Object)c.getInnerArchive().getPath());
        Assert.assertEquals((Object)"dir/inner.mok", (Object)c.getInnerEntryName());
        b = new TFile("../removed.dir/removed.dir/../../dir/./inner.mok/removed.dir/removed.dir/../../dir/./test.txt");
        c = new TFile((File)a, b.getPath());
        Assert.assertFalse((boolean)c.isArchive());
        Assert.assertTrue((boolean)c.isEntry());
        Assert.assertEquals((Object)("outer.mok" + fs + "removed.mok" + fs + ".." + fs + "removed.dir" + fs + "removed.dir" + fs + ".." + fs + ".." + fs + "dir" + fs + "." + fs + "inner.mok"), (Object)c.getInnerArchive().getPath());
        Assert.assertEquals((Object)"dir/inner.mok", (Object)c.getInnerArchive().getEnclEntryName());
    }

    @Test
    public void testGetParentFile() {
        TFile abcdefgh = new TFile("a/b.mok/c/d/e.mok/f.mok/g/h.mok");
        TFile abcdefg = abcdefgh.getParentFile();
        TFile abcdef = abcdefg.getParentFile();
        TFile abcde = abcdef.getParentFile();
        TFile abcd = abcde.getParentFile();
        TFile abc = abcd.getParentFile();
        TFile ab = abc.getParentFile();
        TFile a = ab.getParentFile();
        TFile n = a.getParentFile();
        Assert.assertEquals((Object)abcdefgh.getInnerArchive(), (Object)abcdefgh);
        Assert.assertEquals((Object)abcdefgh.getEnclArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdefg.getInnerArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdefg.getEnclArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdef.getInnerArchive(), (Object)abcdef);
        Assert.assertEquals((Object)abcdef.getEnclArchive(), (Object)abcde);
        Assert.assertEquals((Object)abcde.getInnerArchive(), (Object)abcde);
        Assert.assertEquals((Object)abcde.getEnclArchive(), (Object)ab);
        Assert.assertEquals((Object)abcd.getInnerArchive(), (Object)ab);
        Assert.assertEquals((Object)abcd.getEnclArchive(), (Object)ab);
        Assert.assertEquals((Object)abc.getInnerArchive(), (Object)ab);
        Assert.assertEquals((Object)abc.getEnclArchive(), (Object)ab);
        Assert.assertEquals((Object)ab.getInnerArchive(), (Object)ab);
        Assert.assertEquals((Object)ab.getEnclArchive(), null);
        Assert.assertEquals((Object)a.getInnerArchive(), null);
        Assert.assertEquals((Object)a.getEnclArchive(), null);
        Assert.assertNull((Object)n);
    }

    @Test
    public void testNormalizedAbsoluteFile() throws IOException {
        this.testNormalizedAbsoluteFile("", "");
        this.testNormalizedAbsoluteFile(".", ".");
        this.testNormalizedAbsoluteFile("..", "..");
        this.testNormalizedAbsoluteFile("a", "a");
        this.testNormalizedAbsoluteFile("a", "a/.");
        this.testNormalizedAbsoluteFile("a b", "a b");
        this.testNormalizedAbsoluteFile(".", "a/..");
        this.testNormalizedAbsoluteFile("b", "a/../b");
        this.testNormalizedAbsoluteFile("b", "a/../b/.");
        this.testNormalizedAbsoluteFile(".", "a/../b/..");
        this.testNormalizedAbsoluteFile("c", "a/../b/../c");
        this.testNormalizedAbsoluteFile("c", "a/../b/../c/.");
        this.testNormalizedAbsoluteFile(".", "a/../b/../c/..");
        this.testNormalizedAbsoluteFile("../a", "../a");
        this.testNormalizedAbsoluteFile("../a", "../a/.");
        this.testNormalizedAbsoluteFile("..", "../a/..");
        this.testNormalizedAbsoluteFile("../b", "../a/../b");
        this.testNormalizedAbsoluteFile("../b", "../a/../b/.");
        this.testNormalizedAbsoluteFile("..", "../a/../b/..");
        this.testNormalizedAbsoluteFile("../c", "../a/../b/../c");
        this.testNormalizedAbsoluteFile("../c", "../a/../b/../c/.");
        this.testNormalizedAbsoluteFile("..", "../a/../b/../c/..");
        this.testNormalizedAbsoluteFile("../a", "../a");
        this.testNormalizedAbsoluteFile("../a", "../a/.");
        this.testNormalizedAbsoluteFile("../a/b", "../a/b");
        this.testNormalizedAbsoluteFile("../a/b", "../a/b/.");
        this.testNormalizedAbsoluteFile("../a", "../a/b/..");
        this.testNormalizedAbsoluteFile("../a/c", "../a/b/../c");
        this.testNormalizedAbsoluteFile("../a/c", "../a/b/../c/.");
        this.testNormalizedAbsoluteFile("../a", "../a/b/../c/..");
    }

    void testNormalizedAbsoluteFile(String result, String path) throws IOException {
        File resultFile = new File(result).getCanonicalFile();
        File pathFile = new File(new TFile(path).getNormalizedAbsoluteFile().getPath());
        Assert.assertEquals((Object)resultFile, (Object)pathFile);
    }

    @Test
    public void testGetTopLevelArchive() {
        TFile file = new TFile("abc/def.mok/efg.mok/hij.mok/test.txt");
        Assert.assertEquals((Object)new File("abc/def.mok"), (Object)file.getTopLevelArchive());
    }

    @Test
    public void testUriAndFsPathConversion() {
        for (String[] params : new String[][]{{"/file", "file:/file"}, {"/archive.mok", "mok:file:/archive.mok!/"}, {"/archive.mok/entry", "mok:file:/archive.mok!/entry"}, {"/foo.mok1/bar.mok2", "mok2:mok1:file:/foo.mok1!/bar.mok2!/"}, {"/dist.mok1/app.mok2/META-INF/MANIFEST.MF", "mok2:mok1:file:/dist.mok1!/app.mok2!/META-INF/MANIFEST.MF"}}) {
            String name = params[0];
            URI uri = URI.create(params[1]);
            FsNodePath path = FsNodePath.create((URI)URI.create(params[1]));
            TFile file = new TFile(name);
            Assert.assertThat((Object)new TFile(name), (Matcher)CoreMatchers.equalTo((Object)file));
            Assert.assertThat((Object)new TFile(uri), (Matcher)CoreMatchers.equalTo((Object)file));
            Assert.assertThat((Object)new TFile(path), (Matcher)CoreMatchers.equalTo((Object)file));
            Assert.assertThat((Object)new TFile(name).getUri(), (Matcher)CoreMatchers.equalTo((Object)file.getUri()));
            Assert.assertThat((Object)new TFile(uri).getUri(), (Matcher)CoreMatchers.equalTo((Object)file.getUri()));
            Assert.assertThat((Object)new TFile(path).getUri(), (Matcher)CoreMatchers.equalTo((Object)file.getUri()));
            Assert.assertThat((Object)new TFile(name).getNodePath(), (Matcher)CoreMatchers.equalTo((Object)file.getNodePath()));
            Assert.assertThat((Object)new TFile(uri).getNodePath(), (Matcher)CoreMatchers.equalTo((Object)file.getNodePath()));
            Assert.assertThat((Object)new TFile(path).getNodePath(), (Matcher)CoreMatchers.equalTo((Object)file.getNodePath()));
            Assert.assertThat((Object)new TFile(new TFile(name).getUri()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(uri).getUri()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(path).getUri()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(name).getNodePath()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(uri).getNodePath()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
            Assert.assertThat((Object)new TFile(new TFile(path).getNodePath()), (Matcher)CoreMatchers.equalTo((Object)file.getAbsoluteFile()));
        }
    }

    @Test
    public void testIssue154() {
        for (String param : new String[]{"mok:file:/foo!/", "mok:mok:file:/foo!/bar!/"}) {
            FsNodePath path = FsNodePath.create((URI)URI.create(param));
            try {
                TFileTest.assertIssue154(new TFile(path));
                TFileTest.assertIssue154(new TFile(path.getUri()));
            }
            catch (ServiceConfigurationError error) {
                throw new AssertionError(param, error);
            }
        }
    }

    private static void assertIssue154(TFile file) {
        while (null != file) {
            Assert.assertTrue((boolean)file.isArchive());
            file.exists();
            file = file.getEnclArchive();
        }
    }
}

