/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import net.java.truevfs.access.MockArchiveDriverTestBase;
import net.java.truevfs.access.TFileSystem;
import net.java.truevfs.kernel.spec.FsMountPoint;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TFileSystemTest
extends MockArchiveDriverTestBase {
    @Test
    public void testNewFileSystem() throws IOException {
        for (String[] params : new String[][]{{"tpath:/", "file:/"}, {"tpath:///", "file:/"}, {"tpath:/foo", "file:/"}, {"tpath:/foo/", "file:/"}, {"tpath:/foo/bar", "file:/foo/"}, {"tpath:/foo/bar/", "file:/foo/"}, {"tpath:/foo/bar.mok/", "mok:file:/foo/bar.mok!/"}, {"tpath:/foo.mok/bar", "mok:file:/foo.mok!/"}, {"tpath:/foo.mok/bar.mok", "mok:mok:file:/foo.mok!/bar.mok!/"}}) {
            URI uri = URI.create(params[0]);
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            TFileSystem fs = (TFileSystem)FileSystems.newFileSystem(uri, this.getEnvironment(), TFileSystemTest.class.getClassLoader());
            fs.close();
            Assert.assertThat((Object)fs.isOpen(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)fs.getMountPoint(), (Matcher)CoreMatchers.is((Object)mountPoint));
        }
    }
}

