/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Provider;
import net.java.truecommons.shed.ExtensionSet;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.mock.MockArchiveDriver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public final class TArchiveDetectorTest {
    private final FsArchiveDriver<?> driver = new MockArchiveDriver();
    private final TArchiveDetector ALL = new TArchiveDetector("tar.gz|zip", this.driver);
    private final TArchiveDetector NULL = new TArchiveDetector((Provider)this.ALL, "");
    private final TArchiveDetector MOK = new TArchiveDetector((Provider)this.NULL, "mok", this.driver);

    @Test
    public void testIllegalConstructors() throws Throwable {
        for (TArchiveDetector delegate : new TArchiveDetector[]{this.NULL, this.ALL}) {
            try {
                new TArchiveDetector((Provider)delegate, (Object[][])new Object[][]{{"foo", "java.lang.Object"}, {"bar", "java.io.FilterInputStream"}});
                Assert.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
        this.assertIllegalConstructors(NullPointerException.class, new Object[][]{{null, null}, {null, this.driver}, {null, null, null}, {null, null, this.driver}, {null, "xyz", null}, {null, "xyz", this.driver}, {this.NULL, null, null}, {this.NULL, null, this.driver}, {null, new Object[][]{{"xyz", MockArchiveDriver.class}}}, {this.NULL, null}, {this.NULL, new Object[][]{{null, null}}}, {this.NULL, new Object[][]{{null, ""}}}, {this.NULL, new Object[][]{{null, "xyz"}}}});
        this.assertIllegalConstructors(IllegalArgumentException.class, new Object[][]{{"DRIVER"}, {"DEFAULT"}, {"NULL"}, {"ALL"}, {"unknownExtension"}, {"", this.driver}, {".", this.driver}, {"|", this.driver}, {"|.", this.driver}, {"||", this.driver}, {"||.", this.driver}, {"|.|", this.driver}, {"|.|.", this.driver}, {this.NULL, "", this.driver}, {this.NULL, ".", this.driver}, {this.NULL, "|", this.driver}, {this.NULL, "|.", this.driver}, {this.NULL, "||", this.driver}, {this.NULL, "||.", this.driver}, {this.NULL, "|.|", this.driver}, {this.NULL, "|.|.", this.driver}, {this.NULL, new Object[][]{{"", this.driver}}}, {this.NULL, new Object[][]{{".", this.driver}}}, {this.NULL, new Object[][]{{"|", this.driver}}}, {this.NULL, new Object[][]{{"|.", this.driver}}}, {this.NULL, new Object[][]{{"||", this.driver}}}, {this.NULL, new Object[][]{{"||.", this.driver}}}, {this.NULL, new Object[][]{{"|.|", this.driver}}}, {this.NULL, new Object[][]{{"|.|.", this.driver}}}, {this.NULL, new Object[][]{{"anyExtension", ""}}}, {this.NULL, new Object[][]{{"anyExtension", "xyz"}}}, {this.NULL, new Object[][]{{MockArchiveDriver.class, this.driver}}}, {this.NULL, new Object[][]{{this.driver, this.driver}}}, {this.NULL, new Object[][]{{"anyExtension", new Object()}}}, {this.NULL, new Object[][]{{"anyExtension", Object.class}}}});
    }

    private void assertIllegalConstructors(Class<? extends Throwable> expected, Object[][] list) throws Throwable {
        for (int i = 0; i < list.length; ++i) {
            Object[] args = list[i];
            Object arg0 = args[0];
            try {
                switch (args.length) {
                    case 1: {
                        new TArchiveDetector((String)arg0);
                        Assert.fail((String)("Index " + i));
                        break;
                    }
                    case 2: {
                        Object arg1 = args[1];
                        if (arg0 != null) {
                            if (arg1 != null) {
                                if (arg0 instanceof String) {
                                    new TArchiveDetector((String)arg0, (FsDriver)((FsArchiveDriver)arg1));
                                } else if (arg1 instanceof Object[][]) {
                                    new TArchiveDetector((Provider)((TArchiveDetector)arg0), (Object[][])arg1);
                                } else {
                                    new TArchiveDetector((Provider)((TArchiveDetector)arg0), (Map)arg1);
                                }
                                Assert.fail((String)("Index " + i));
                                break;
                            }
                            assert (arg0 != null);
                            assert (arg1 == null);
                            if (arg0 instanceof String) {
                                new TArchiveDetector((String)arg0, null);
                                Assert.fail((String)("Index " + i));
                                break;
                            }
                            try {
                                new TArchiveDetector((Provider)((TArchiveDetector)arg0), (Object[][])null);
                                Assert.fail((String)("Index " + i));
                            }
                            catch (Throwable failure) {
                                Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                            }
                            try {
                                new TArchiveDetector((Provider)((TArchiveDetector)arg0), (Map)null);
                                Assert.fail((String)("Index " + i));
                            }
                            catch (Throwable failure) {
                                Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                            }
                            break;
                        }
                        assert (arg0 == null);
                        if (arg1 != null) {
                            if (arg1 instanceof FsArchiveDriver) {
                                new TArchiveDetector(null, (FsDriver)((FsArchiveDriver)arg1));
                            } else if (arg1 instanceof Object[][]) {
                                new TArchiveDetector(null, (Object[][])arg1);
                            } else {
                                new TArchiveDetector(null, (Map)arg1);
                            }
                            Assert.fail((String)("Index " + i));
                            break;
                        }
                        assert (arg0 == null);
                        assert (arg1 == null);
                        try {
                            new TArchiveDetector((String)null, null);
                            Assert.fail((String)("Index " + i));
                        }
                        catch (Throwable failure) {
                            Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                        }
                        try {
                            new TArchiveDetector(null, (Object[][])null);
                            Assert.fail((String)("Index " + i));
                        }
                        catch (Throwable failure) {
                            Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                        }
                        try {
                            new TArchiveDetector(null, (Map)null);
                            Assert.fail((String)("Index " + i));
                        }
                        catch (Throwable failure) {
                            Assert.assertTrue((boolean)expected.isAssignableFrom(failure.getClass()));
                        }
                        break;
                    }
                    case 3: {
                        Object arg1 = args[1];
                        Object arg2 = args[2];
                        new TArchiveDetector((Provider)((TArchiveDetector)arg0), (String)arg1, (FsDriver)((FsArchiveDriver)arg2));
                        Assert.fail((String)("Index " + i));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                continue;
            }
            catch (Throwable ex) {
                if (expected.isAssignableFrom(ex.getClass())) continue;
                throw ex;
            }
        }
    }

    @Test
    public void testGetExtensions() {
        this.assertExtensions(new String[]{"zip", "zip", "zip", ".zip", "zip", "|zip", "zip", "zip|", "zip", "zip|zip", "zip", "zip|.zip", "zip", "zip||zip", "zip", "zip|zip|", "zip", ".zip|", "zip", ".zip|zip", "zip", ".zip|.zip", "zip", ".zip||zip", "zip", ".zip|zip|", "zip", "|zip|", "zip", "|zip|zip", "zip", "|zip|.zip", "zip", "|zip||zip", "zip", "|zip|zip|", "zip", "ZIP", "zip", ".ZIP", "zip", "|ZIP", "zip", "ZIP|", "zip", "ZIP|ZIP", "zip", "ZIP|.ZIP", "zip", "ZIP||ZIP", "zip", "ZIP|ZIP|", "zip", ".ZIP|", "zip", ".ZIP|ZIP", "zip", ".ZIP|.ZIP", "zip", ".ZIP||ZIP", "zip", ".ZIP|ZIP|", "zip", "|ZIP|", "zip", "|ZIP|ZIP", "zip", "|ZIP|.ZIP", "zip", "|ZIP||ZIP", "zip", "|ZIP|ZIP|", "tar.gz|zip", "TAR.GZ|ZIP", "tar.gz|zip", "ZIP|TAR.GZ", "tar.gz|zip", "|ZIP|TAR.GZ", "tar.gz|zip", "ZIP|TAR.GZ|", "tar.gz|zip", "|ZIP|TAR.GZ|", "tar.gz|zip", "||ZIP|TAR.GZ|", "tar.gz|zip", "|ZIP||TAR.GZ|", "tar.gz|zip", "|ZIP|TAR.GZ||", "tar.gz|zip", ".TAR.GZ|.ZIP", "tar.gz|zip", ".ZIP|.TAR.GZ", "tar.gz|zip", "|.ZIP|.TAR.GZ", "tar.gz|zip", ".ZIP|.TAR.GZ|", "tar.gz|zip", "|.ZIP|.TAR.GZ|", "tar.gz|zip", "||.ZIP|.TAR.GZ|", "tar.gz|zip", "|.ZIP||.TAR.GZ|", "tar.gz|zip", "|.ZIP|.TAR.GZ||"});
    }

    private void assertExtensions(String[] args) {
        int i = 0;
        while (i < args.length) {
            String result = args[i++];
            String extensions = args[i++];
            TArchiveDetector detector = new TArchiveDetector(extensions, this.driver);
            Assert.assertEquals((Object)result, (Object)detector.getExtensions());
            detector = new TArchiveDetector((Provider)this.NULL, extensions, this.driver);
            Assert.assertEquals((Object)result, (Object)detector.getExtensions());
            detector = new TArchiveDetector((Provider)this.NULL, (Object[][])new Object[][]{{extensions, this.driver}});
            Assert.assertEquals((Object)result, (Object)detector.getExtensions());
        }
    }

    @Test
    public void testNullMapping() {
        for (TArchiveDetector delegate : new TArchiveDetector[]{this.NULL, this.ALL}) {
            TArchiveDetector detector = new TArchiveDetector((Provider)delegate, "zip", null);
            Assert.assertFalse((boolean)new ExtensionSet(detector.getExtensions()).contains((Object)"zip"));
            detector = new TArchiveDetector((Provider)delegate, ".ZIP", null);
            Assert.assertFalse((boolean)new ExtensionSet(detector.getExtensions()).contains((Object)"zip"));
        }
    }

    @Test
    public void testGetDriver() {
        this.assertScheme(new String[][]{{null, ""}, {null, "."}, {null, ".all"}, {null, ".default"}, {null, ".ear"}, {null, ".exe"}, {null, ".file"}, {null, ".null"}, {null, ".z"}, {null, "test"}, {null, "test."}, {null, "test.all"}, {null, "test.default"}, {null, "test.null"}, {null, "test.z"}}, this.NULL, this.MOK, this.ALL);
        this.assertScheme(new String[][]{{null, ".tar.gz"}, {null, ".zip"}, {null, "test.tar.gz"}, {null, "test.zip"}}, this.NULL, this.MOK);
        this.assertScheme(new String[][]{{"tar.gz", ".tar.gz"}, {"tar.gz", "test.tar.gz"}, {"tar.gz", "foo" + File.separator + "test.123.tar.gz"}, {"zip", ".zip"}, {"zip", "test.zip"}, {"zip", "foo" + File.separator + "test.123.zip"}}, this.ALL);
    }

    private void assertScheme(String[][] tests, TArchiveDetector ... detectors) {
        for (TArchiveDetector detector : detectors) {
            try {
                detector.scheme(null);
                Assert.fail((String)"Expected NullPointerException!");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            for (String[] test2 : tests) {
                FsScheme scheme = test2[0] == null ? null : FsScheme.create((String)test2[0]);
                String path = test2[1];
                this.assertScheme(detector, scheme, path);
                detector = new TArchiveDetector((Provider)detector, new Object[0][0]);
                this.assertScheme(detector, scheme, path);
            }
        }
    }

    private void assertScheme(TArchiveDetector detector, @Nullable FsScheme scheme, String path) {
        String lpath = path.toLowerCase(Locale.ROOT);
        String upath = path.toUpperCase(Locale.ROOT);
        Assert.assertThat((Object)detector.scheme(lpath), (Matcher)CoreMatchers.equalTo((Object)scheme));
        Assert.assertThat((Object)detector.scheme(upath), (Matcher)CoreMatchers.equalTo((Object)scheme));
    }
}

