/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import net.java.truecommons.services.Factory;
import net.java.truecommons.services.ServiceLocator;
import net.java.truecommons.shed.ExtensionSet;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsArchiveDriverTestBase;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;
import net.java.truevfs.kernel.spec.spi.FsManagerDecorator;
import net.java.truevfs.kernel.spec.spi.FsManagerFactory;

public abstract class ConfiguredClientTestBase<D extends FsArchiveDriver<?>>
extends FsArchiveDriverTestBase<D> {
    protected static final long TIMEOUT_MILLIS = 50L;
    protected static final FsMountPoint ROOT_DIRECTORY = FsMountPoint.create((URI)URI.create("file:/"));
    protected static final FsMountPoint CURRENT_DIRECTORY = FsMountPoint.create((URI)new File("").toURI());
    protected static final String[] NO_STRINGS = new String[0];
    private static final String ARCHIVE_DETECTOR = "archiveDetector";
    private static volatile Factory<FsManager> managerFactory;
    private TConfig config;
    private Map<String, ?> environment;

    private static FsManager newManager() {
        Factory f = managerFactory;
        return (FsManager)(null != f ? f : (managerFactory = new ServiceLocator(FsManagerLocator.class).factory(FsManagerFactory.class, FsManagerDecorator.class))).get();
    }

    public void setUp() throws IOException {
        super.setUp();
        this.config = TConfig.open();
        if (ISOLATE_FS_MANAGER) {
            this.config.setManager(ConfiguredClientTestBase.newManager());
        }
        TArchiveDetector detector = new TArchiveDetector(this.getExtensionList(), (FsDriver)this.getArchiveDriver());
        this.environment = Collections.singletonMap(ARCHIVE_DETECTOR, detector);
        this.config.setArchiveDetector(detector);
        this.config.setLenient(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        try {
            this.config.close();
        }
        finally {
            super.tearDown();
        }
    }

    protected abstract String getExtensionList();

    protected final FsScheme getScheme() {
        return FsScheme.create((String)((String)new ExtensionSet(this.getExtensionList()).iterator().next()));
    }

    protected final String getExtension() {
        return "." + this.getScheme();
    }

    protected final TConfig getConfig() {
        return this.config;
    }

    protected final Map<String, ?> getEnvironment() {
        return this.environment;
    }

    protected final FsController controller(FsNodePath nodePath) {
        return this.getConfig().getManager().controller((FsCompositeDriver)this.getConfig().getArchiveDetector(), nodePath.getMountPoint());
    }
}

