/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.util.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.java.trueupdate.util.builder.AbstractBuilder;

public class ImmutableListBuilder<I, P>
extends AbstractBuilder<P> {
    private final List<I> items = new LinkedList<I>();

    public static <I> ImmutableListBuilder<I, Void> create() {
        return new ImmutableListBuilder();
    }

    public final ImmutableListBuilder<I, P> clear() {
        this.items.clear();
        return this;
    }

    public final ImmutableListBuilder<I, P> add(@Nullable I item) {
        this.items.add(item);
        return this;
    }

    public final ImmutableListBuilder<I, P> add(I ... items) {
        for (I item : items) {
            this.items.add(item);
        }
        return this;
    }

    public final ImmutableListBuilder<I, P> set(@Nullable I item) {
        return this.clear().add(item);
    }

    public final ImmutableListBuilder<I, P> set(I ... items) {
        return this.clear().add(items);
    }

    public final ImmutableListBuilder<I, P> addAll(Collection<? extends I> collection) {
        this.items.addAll(collection);
        return this;
    }

    public final ImmutableListBuilder<I, P> setAll(Collection<? extends I> collection) {
        return this.clear().addAll(collection);
    }

    @Override
    public final List<I> build() {
        int size = this.items.size();
        return 0 == size ? Collections.EMPTY_LIST : (1 == size ? Collections.singletonList(this.items.get(0)) : Collections.unmodifiableList(new ArrayList<I>(this.items)));
    }
}

