/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SystemProperties {
    private static Pattern REFERENCE_PATTERN = Pattern.compile("\\$\\{([^\\}]*)\\}");

    private SystemProperties() {
    }

    @Nullable
    public static String resolve(@CheckForNull String string, @Nullable String defaultValue) {
        return null == string ? defaultValue : SystemProperties.resolve(string);
    }

    public static String resolve(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        Matcher matcher = REFERENCE_PATTERN.matcher(string);
        boolean found = false;
        while (matcher.find()) {
            found = true;
            matcher.appendReplacement(sb, SystemProperties.replacement(matcher));
        }
        return found ? matcher.appendTail(sb).toString() : string;
    }

    private static String replacement(Matcher matcher) {
        String key = matcher.group(1);
        String value = System.getProperty(key);
        if (null == value) {
            throw new IllegalArgumentException("Unknown system property key \"" + key + "\".");
        }
        return value;
    }
}

