/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.util;

import java.net.URL;
import java.util.Enumeration;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Resources {
    public static URL locate(String name) throws ServiceConfigurationError {
        URL url;
        Enumeration<URL> en;
        try {
            en = Thread.currentThread().getContextClassLoader().getResources(name);
            url = en.nextElement();
        }
        catch (Exception ex) {
            throw new ServiceConfigurationError(String.format("Cannot locate resource %s on the class path.", name), ex);
        }
        if (en.hasMoreElements()) {
            Logger.getLogger(Resources.class.getName()).log(Level.WARNING, "There is more than one resource with the name {0} on the class path. Selecting {1} .", new Object[]{name, url});
        }
        return url;
    }

    private Resources() {
    }
}

