/*
 * Copyright (C) 2013 Schlichtherle IT Services & Stimulus Software.
 * All rights reserved. Use is subject to license terms.
 */
package net.java.trueupdate.util;

import java.net.URL;
import java.util.*;
import java.util.logging.*;
import javax.annotation.concurrent.Immutable;

/**
 * Provides functions for dealing with resources on the class path.
 *
 * @author Christian Schlichtherle
 */
@Immutable
public final class Resources {

    public static URL locate(final String name) throws ServiceConfigurationError {
        final Enumeration<URL> en;
        final URL url;
        try {
            en = Thread.currentThread()
                    .getContextClassLoader().getResources(name);
            url = en.nextElement();
        } catch (Exception ex) {
            throw new ServiceConfigurationError(String.format(
                    "Cannot locate resource %s on the class path.", name), ex);
        }
        if (en.hasMoreElements())
            Logger.getLogger(Resources.class.getName()).log(Level.WARNING,
                    "There is more than one resource with the name {0} on the class path. Selecting {1} .",
                    new Object[] { name, url });
        return url;
    }

    private Resources() { }
}
