/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.shed;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SystemProperties {
    private static Pattern REFERENCE_PATTERN = Pattern.compile("\\$\\{([^\\}]*)\\}");

    private SystemProperties() {
    }

    public static String resolve(String string) {
        StringBuffer result = new StringBuffer(string.length());
        Matcher matcher = REFERENCE_PATTERN.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(result, SystemProperties.replacement(matcher));
        }
        return matcher.appendTail(result).toString();
    }

    private static String replacement(Matcher matcher) {
        String key = matcher.group(1);
        String value = System.getProperty(key);
        if (null == value) {
            throw new IllegalArgumentException("Unknown system property key \"" + key + "\".");
        }
        return value;
    }
}

