/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec.tx;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.trueupdate.manager.spec.tx.Transaction;

public class Transactions {
    private static final ThreadLocal<Boolean> inTx = new InheritableThreadLocal<Boolean>();

    private static Logger logger() {
        return Logger.getLogger(Transactions.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Transaction tx) throws Exception {
        if (Boolean.TRUE.equals(inTx.get())) {
            throw new IllegalStateException("Nested transactions are not supported because they can't get rolled back once committed - refactor to CompositeTransaction instead.");
        }
        inTx.set(Boolean.TRUE);
        try {
            tx.prepare();
            try {
                tx.perform();
            }
            catch (Exception ex) {
                try {
                    tx.rollback();
                }
                catch (RuntimeException ex2) {
                    Transactions.logger().log(Level.SEVERE, "Exception while rolling back transaction - system may be in inconsistent state:", ex2);
                }
                throw ex;
            }
            try {
                tx.commit();
            }
            catch (RuntimeException ex) {
                Transactions.logger().log(Level.SEVERE, "Exception while committing transaction - system may be in inconsistent state.");
                throw ex;
            }
        }
        finally {
            inTx.remove();
        }
    }

    public static Transaction noOp() {
        return new NullTransaction();
    }

    public static Transaction time(final String message, final Transaction tx, final LoggerConfig config) {
        class Time
        extends Transaction {
            Time() {
            }

            @Override
            public void prepare() throws Exception {
                this.time(Method.prepare, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        tx.prepare();
                        return null;
                    }
                });
            }

            @Override
            public void perform() throws Exception {
                this.time(Method.perform, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        tx.perform();
                        return null;
                    }
                });
            }

            @Override
            public void rollback() {
                this.timeUnchecked(Method.rollback, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        tx.rollback();
                        return null;
                    }
                });
            }

            @Override
            public void commit() {
                this.timeUnchecked(Method.commit, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        tx.commit();
                        return null;
                    }
                });
            }

            void timeUnchecked(Method method, Callable<Void> task) {
                try {
                    this.time(method, task);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new AssertionError((Object)ex);
                }
            }

            void time(Method method, Callable<Void> task) throws Exception {
                Exception ex = null;
                long started = System.currentTimeMillis();
                try {
                    task.call();
                }
                catch (Exception ex2) {
                    ex = ex2;
                }
                long finished = System.currentTimeMillis();
                Logger logger = config.logger();
                boolean succeeded = null == ex;
                Level level = config.level(method, succeeded);
                if (logger.isLoggable(level)) {
                    long duration = finished - started;
                    long millis = duration % 1000L;
                    long seconds = duration / 1000L % 60L;
                    long minutes = duration / 1000L / 60L % 60L;
                    long hours = duration / 1000L / 60L / 60L;
                    logger.log(level, message, new Object[]{succeeded ? 0 : 1, method.ordinal(), hours, minutes, seconds, millis});
                }
                if (!succeeded) {
                    throw ex;
                }
            }
        }
        return new Time();
    }

    private Transactions() {
    }

    public static abstract class LoggerConfig {
        public abstract Logger logger();

        public Level level(Method method, boolean succeeded) {
            return succeeded ? method.succeeded() : method.failed();
        }
    }

    public static enum Method {
        prepare{

            @Override
            Level succeeded() {
                return Level.FINE;
            }
        }
        ,
        perform,
        rollback,
        commit{

            @Override
            Level succeeded() {
                return Level.FINE;
            }
        };


        Level succeeded() {
            return Level.INFO;
        }

        Level failed() {
            return Level.SEVERE;
        }
    }

    private static class NullTransaction
    extends Transaction {
        private NullTransaction() {
        }

        @Override
        public void perform() throws Exception {
        }

        @Override
        public void rollback() {
        }
    }
}

