/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec.tx;

import net.java.trueupdate.manager.spec.tx.Transaction;

public final class CompositeTransaction
extends Transaction {
    private final Transaction[] txs;
    private int index;

    public CompositeTransaction(Transaction ... txs) {
        if (0 >= txs.length) {
            throw new IllegalArgumentException();
        }
        this.txs = (Transaction[])txs.clone();
    }

    @Override
    public void prepare() throws Exception {
        if (0 != this.index) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void perform() throws Exception {
        while (this.index < this.txs.length) {
            Transaction tx = this.txs[this.index];
            tx.prepare();
            ++this.index;
            tx.perform();
        }
    }

    @Override
    public void rollback() {
        while (0 < this.index) {
            this.txs[--this.index].rollback();
        }
    }

    @Override
    public void commit() {
        while (0 < this.index) {
            this.txs[--this.index].commit();
        }
    }
}

