/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.shed.Objects;
import net.java.trueupdate.shed.Strings;

@Immutable
public final class UpdateDescriptor
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final ArtifactDescriptor artifactDescriptor;
    private final String updateVersion;

    UpdateDescriptor(Builder<?> b) {
        this.artifactDescriptor = (ArtifactDescriptor)Objects.requireNonNull((Object)b.artifactDescriptor);
        this.updateVersion = Strings.requireNonEmpty((String)b.updateVersion);
    }

    public Builder<Void> update() {
        return UpdateDescriptor.builder().artifactDescriptor(this.artifactDescriptor()).updateVersion(this.updateVersion());
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public ArtifactDescriptor artifactDescriptor() {
        return this.artifactDescriptor;
    }

    public UpdateDescriptor artifactDescriptor(ArtifactDescriptor artifactDescriptor) {
        return this.artifactDescriptor().equals((Object)artifactDescriptor) ? this : this.update().artifactDescriptor(artifactDescriptor).build();
    }

    public String updateVersion() {
        return this.updateVersion;
    }

    public UpdateDescriptor updateVersion(String updateVersion) {
        return this.updateVersion().equals(updateVersion) ? this : this.update().updateVersion(updateVersion).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateDescriptor)) {
            return false;
        }
        UpdateDescriptor that = (UpdateDescriptor)obj;
        return this.artifactDescriptor().equals((Object)that.artifactDescriptor()) && this.updateVersion().equals(that.updateVersion());
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.artifactDescriptor().hashCode();
        hash = 31 * hash + this.updateVersion.hashCode();
        return hash;
    }

    public static class Builder<T> {
        @CheckForNull
        ArtifactDescriptor artifactDescriptor;
        @CheckForNull
        String updateVersion;

        protected Builder() {
        }

        public ArtifactDescriptor.Builder<Builder<T>> artifactDescriptor() {
            return new ArtifactDescriptor.Builder<Builder<T>>(){

                public Builder<T> inject() {
                    return Builder.this.artifactDescriptor(this.build());
                }
            };
        }

        public Builder<T> artifactDescriptor(@Nullable ArtifactDescriptor artifactDescriptor) {
            this.artifactDescriptor = artifactDescriptor;
            return this;
        }

        public Builder<T> updateVersion(@Nullable String updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        public UpdateDescriptor build() {
            return new UpdateDescriptor(this);
        }

        public T inject() {
            throw new IllegalStateException("No target for injection.");
        }
    }
}

