/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.manager.spec.ApplicationDescriptor;
import net.java.trueupdate.manager.spec.UpdateDescriptor;
import net.java.trueupdate.manager.spec.UpdateMessageListener;
import net.java.trueupdate.shed.Objects;

@Immutable
public final class UpdateMessage
implements Serializable {
    private static final long serialVersionUID = 0L;
    static final URI EMPTY_URI = URI.create("");
    private final long timestamp;
    private final URI from;
    private final URI to;
    private final Type type;
    private final ArtifactDescriptor artifactDescriptor;
    private final String updateVersion;
    private final String status;
    private final URI currentLocation;
    private final URI updateLocation;

    UpdateMessage(Builder b) {
        this.timestamp = UpdateMessage.nonNullOrNow(b.timestamp);
        this.from = (URI)Objects.requireNonNull((Object)b.from);
        this.to = (URI)Objects.requireNonNull((Object)b.to);
        this.type = (Type)((Object)Objects.requireNonNull((Object)((Object)b.type)));
        this.artifactDescriptor = (ArtifactDescriptor)Objects.requireNonNull((Object)b.artifactDescriptor);
        this.updateVersion = (String)Objects.nonNullOr((Object)b.updateVersion, (Object)"");
        this.currentLocation = (URI)Objects.nonNullOr((Object)b.currentLocation, (Object)EMPTY_URI);
        this.updateLocation = (URI)Objects.nonNullOr((Object)b.updateLocation, (Object)this.currentLocation);
        this.status = (String)Objects.nonNullOr((Object)b.status, (Object)"");
    }

    private static long nonNullOrNow(Long timestamp) {
        return null != timestamp ? timestamp : System.currentTimeMillis();
    }

    public Builder update() {
        return UpdateMessage.builder().timestamp(this.timestamp()).from(this.from()).to(this.to()).type(this.type()).artifactDescriptor(this.artifactDescriptor()).updateVersion(this.updateVersion()).currentLocation(this.currentLocation()).updateLocation(this.updateLocation()).status(this.status());
    }

    public static Builder builder() {
        return new Builder();
    }

    public long timestamp() {
        return this.timestamp;
    }

    public UpdateMessage timestamp(long timestamp) {
        return this.timestamp() == timestamp ? this : this.update().timestamp(timestamp).build();
    }

    public URI from() {
        return this.from;
    }

    public UpdateMessage from(URI from) {
        return this.from().equals(from) ? this : this.update().from(from).build();
    }

    public URI to() {
        return this.to;
    }

    public UpdateMessage to(URI to) {
        return this.to().equals(to) ? this : this.update().to(to).build();
    }

    public Type type() {
        return this.type;
    }

    public UpdateMessage type(Type type) {
        return this.type().equals((Object)type) ? this : this.update().type(type).build();
    }

    public ArtifactDescriptor artifactDescriptor() {
        return this.artifactDescriptor;
    }

    public UpdateMessage artifactDescriptor(ArtifactDescriptor artifactDescriptor) {
        return this.artifactDescriptor().equals((Object)artifactDescriptor) ? this : this.update().artifactDescriptor(artifactDescriptor).build();
    }

    public String updateVersion() {
        return this.updateVersion;
    }

    public UpdateMessage updateVersion(String updateVersion) {
        return this.updateVersion().equals(updateVersion) ? this : this.update().updateVersion(updateVersion).build();
    }

    public URI currentLocation() {
        return this.currentLocation;
    }

    public UpdateMessage currentLocation(URI currentLocation) {
        return this.currentLocation().equals(currentLocation) ? this : this.update().currentLocation(currentLocation).build();
    }

    public URI updateLocation() {
        return this.updateLocation;
    }

    public UpdateMessage updateLocation(URI newLocation) {
        return this.updateLocation().equals(newLocation) ? this : this.update().updateLocation(newLocation).build();
    }

    public String status() {
        return this.status;
    }

    public UpdateMessage status(String status) {
        return this.status().equals(status) ? this : this.update().status(status).build();
    }

    public UpdateMessage successResponse() {
        return this.update().timestamp(null).type(this.type().successResponse()).from(this.to()).to(this.from()).status(null).build();
    }

    public UpdateMessage failureResponse(Exception ex) {
        return this.update().timestamp(null).type(this.type().failureResponse()).from(this.to()).to(this.from()).status(ex.toString()).build();
    }

    public ApplicationDescriptor applicationDescriptor() {
        return ApplicationDescriptor.builder().artifactDescriptor(this.artifactDescriptor()).currentLocation(this.currentLocation()).build();
    }

    public UpdateDescriptor updateDescriptor() {
        return UpdateDescriptor.builder().artifactDescriptor(this.artifactDescriptor()).updateVersion(this.updateVersion()).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateMessage)) {
            return false;
        }
        UpdateMessage that = (UpdateMessage)obj;
        return this.timestamp() == that.timestamp() && this.from().equals(that.from()) && this.to().equals(that.to()) && this.type().equals((Object)that.type()) && this.artifactDescriptor().equals((Object)that.artifactDescriptor()) && this.updateVersion().equals(that.updateVersion()) && this.currentLocation().equals(that.currentLocation()) && this.updateLocation().equals(that.updateLocation()) && this.status().equals(that.status());
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + UpdateMessage.hashCode(this.timestamp);
        hash = 31 * hash + this.from().hashCode();
        hash = 31 * hash + this.to().hashCode();
        hash = 31 * hash + this.type().hashCode();
        hash = 31 * hash + this.artifactDescriptor().hashCode();
        hash = 31 * hash + this.updateVersion().hashCode();
        hash = 31 * hash + this.currentLocation().hashCode();
        hash = 31 * hash + this.updateLocation().hashCode();
        hash = 31 * hash + this.status().hashCode();
        return hash;
    }

    private static int hashCode(long value) {
        return (int)(value >> 32 ^ value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Timestamp: ").append(new Date(this.timestamp())).append('\n').append("From: ").append(this.from()).append('\n').append("To: ").append(this.to()).append('\n').append("Type: ").append((Object)this.type()).append('\n').append("Artifact-Descriptor: ").append(this.artifactDescriptor()).append('\n');
        if (!this.updateVersion().isEmpty()) {
            sb.append("Update-Version: ").append(this.updateVersion()).append('\n');
        }
        if (!this.currentLocation().equals(EMPTY_URI)) {
            sb.append("Current-Location: ").append(this.currentLocation()).append('\n');
        }
        if (!this.updateLocation().equals(EMPTY_URI)) {
            sb.append("Update-Location: ").append(this.updateLocation()).append('\n');
        }
        if (!this.status().isEmpty()) {
            sb.append("Status: ").append(this.status()).append('\n');
        }
        return sb.toString();
    }

    public static final class Builder {
        @CheckForNull
        Long timestamp;
        @CheckForNull
        URI from;
        @CheckForNull
        URI to;
        @CheckForNull
        Type type;
        @CheckForNull
        ArtifactDescriptor artifactDescriptor;
        @CheckForNull
        String updateVersion;
        @CheckForNull
        String status;
        @CheckForNull
        URI currentLocation;
        @CheckForNull
        URI updateLocation;

        Builder() {
        }

        public Builder timestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder from(@Nullable URI from) {
            this.from = from;
            return this;
        }

        public Builder to(@Nullable URI to) {
            this.to = to;
            return this;
        }

        public Builder type(@Nullable Type type) {
            this.type = type;
            return this;
        }

        public ArtifactDescriptor.Builder<Builder> artifactDescriptor() {
            return new ArtifactDescriptor.Builder<Builder>(){

                public Builder inject() {
                    return Builder.this.artifactDescriptor(this.build());
                }
            };
        }

        public Builder artifactDescriptor(@Nullable ArtifactDescriptor artifactDescriptor) {
            this.artifactDescriptor = artifactDescriptor;
            return this;
        }

        public Builder updateVersion(@Nullable String updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        public Builder currentLocation(@Nullable URI currentLocation) {
            this.currentLocation = currentLocation;
            return this;
        }

        public Builder updateLocation(@Nullable URI updateLocation) {
            this.updateLocation = updateLocation;
            return this;
        }

        public Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public UpdateMessage build() {
            return new UpdateMessage(this);
        }
    }

    public static enum Type {
        SUBSCRIPTION_NOTICE{

            @Override
            public boolean forManager() {
                return true;
            }

            @Override
            public Type successResponse() {
                return SUBSCRIPTION_SUCCESS_RESPONSE;
            }

            @Override
            public Type failureResponse() {
                return SUBSCRIPTION_FAILURE_RESPONSE;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onSubscriptionNotice(message);
            }
        }
        ,
        SUBSCRIPTION_REQUEST{

            @Override
            public boolean forManager() {
                return true;
            }

            @Override
            public Type successResponse() {
                return SUBSCRIPTION_SUCCESS_RESPONSE;
            }

            @Override
            public Type failureResponse() {
                return SUBSCRIPTION_FAILURE_RESPONSE;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onSubscriptionRequest(message);
            }
        }
        ,
        SUBSCRIPTION_SUCCESS_RESPONSE{

            @Override
            public boolean forManager() {
                return false;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onSubscriptionSuccessResponse(message);
            }
        }
        ,
        SUBSCRIPTION_FAILURE_RESPONSE{

            @Override
            public boolean forManager() {
                return false;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onSubscriptionFailureResponse(message);
            }
        }
        ,
        UPDATE_NOTICE{

            @Override
            public boolean forManager() {
                return false;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onUpdateNotice(message);
            }
        }
        ,
        INSTALLATION_REQUEST{

            @Override
            public boolean forManager() {
                return true;
            }

            @Override
            public Type successResponse() {
                return INSTALLATION_SUCCESS_RESPONSE;
            }

            @Override
            public Type failureResponse() {
                return INSTALLATION_FAILURE_RESPONSE;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onInstallationRequest(message);
            }
        }
        ,
        INSTALLATION_SUCCESS_RESPONSE{

            @Override
            public boolean forManager() {
                return false;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onInstallationSuccessResponse(message);
            }
        }
        ,
        INSTALLATION_FAILURE_RESPONSE{

            @Override
            public boolean forManager() {
                return false;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onInstallationFailureResponse(message);
            }
        }
        ,
        UNSUBSCRIPTION_NOTICE{

            @Override
            public boolean forManager() {
                return true;
            }

            @Override
            public Type successResponse() {
                return UNSUBSCRIPTION_SUCCESS_RESPONSE;
            }

            @Override
            public Type failureResponse() {
                return UNSUBSCRIPTION_FAILURE_RESPONSE;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onUnsubscriptionNotice(message);
            }
        }
        ,
        UNSUBSCRIPTION_REQUEST{

            @Override
            public boolean forManager() {
                return true;
            }

            @Override
            public Type successResponse() {
                return UNSUBSCRIPTION_SUCCESS_RESPONSE;
            }

            @Override
            public Type failureResponse() {
                return UNSUBSCRIPTION_FAILURE_RESPONSE;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onUnsubscriptionRequest(message);
            }
        }
        ,
        UNSUBSCRIPTION_SUCCESS_RESPONSE{

            @Override
            public boolean forManager() {
                return false;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onUnsubscriptionSuccessResponse(message);
            }
        }
        ,
        UNSUBSCRIPTION_FAILURE_RESPONSE{

            @Override
            public boolean forManager() {
                return false;
            }

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onUnsubscriptionFailureResponse(message);
            }
        };


        public abstract boolean forManager();

        public Type successResponse() {
            throw new UnsupportedOperationException();
        }

        public Type failureResponse() {
            throw new UnsupportedOperationException();
        }

        abstract void dispatchMessageTo(UpdateMessage var1, UpdateMessageListener var2) throws Exception;
    }
}

