/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.spec;

import java.net.URI;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.manager.spec.UpdateMessage;
import net.java.trueupdate.shed.Objects;

@Immutable
public final class ApplicationDescriptor {
    private final ArtifactDescriptor artifactDescriptor;
    private final URI currentLocation;

    ApplicationDescriptor(Builder<?> b) {
        this.artifactDescriptor = (ArtifactDescriptor)Objects.requireNonNull((Object)b.artifactDescriptor);
        this.currentLocation = ApplicationDescriptor.requireNonEmpty(b.currentLocation);
    }

    private static URI requireNonEmpty(URI value) {
        if (value.equals(UpdateMessage.EMPTY_URI)) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public ArtifactDescriptor artifactDescriptor() {
        return this.artifactDescriptor;
    }

    public URI currentLocation() {
        return this.currentLocation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ApplicationDescriptor)) {
            return false;
        }
        ApplicationDescriptor that = (ApplicationDescriptor)obj;
        return this.artifactDescriptor().equals((Object)that.artifactDescriptor()) && this.currentLocation().equals(that.currentLocation());
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.artifactDescriptor().hashCode();
        hash = 31 * hash + this.currentLocation().hashCode();
        return hash;
    }

    public static class Builder<T> {
        @CheckForNull
        ArtifactDescriptor artifactDescriptor;
        @CheckForNull
        URI currentLocation;

        protected Builder() {
        }

        public ArtifactDescriptor.Builder<Builder<T>> artifactDescriptor() {
            return new ArtifactDescriptor.Builder<Builder<T>>(){

                public Builder<T> inject() {
                    return Builder.this.artifactDescriptor(this.build());
                }
            };
        }

        public Builder<T> artifactDescriptor(@Nullable ArtifactDescriptor artifactDescriptor) {
            this.artifactDescriptor = artifactDescriptor;
            return this;
        }

        public Builder<T> currentLocation(@Nullable URI currentLocation) {
            this.currentLocation = currentLocation;
            return this;
        }

        public ApplicationDescriptor build() {
            return new ApplicationDescriptor(this);
        }

        public T inject() {
            throw new IllegalStateException("No target for injection.");
        }
    }
}

