/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.servlets;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import net.java.trueupdate.manager.core.TimerParameters;
import net.java.trueupdate.manager.core.UpdateServiceParameters;
import net.java.trueupdate.manager.jms.JmsUpdateManagerContext;
import net.java.trueupdate.manager.jms.JmsUpdateManagerParameters;

@WebListener
public final class UpdateManagerServletContextListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(UpdateManagerServletContextListener.class.getName());
    private JmsUpdateManagerContext context;

    public void contextInitialized(ServletContextEvent sce) {
        if (null != this.context) {
            return;
        }
        this.context = new JmsUpdateManagerContext();
        JmsUpdateManagerParameters ump = this.context.parameters();
        UpdateServiceParameters usp = ump.updateService();
        logger.log(Level.CONFIG, "The base URI of the update service is {0} .", usp.uri());
        TimerParameters tp = ump.updateTimer();
        logger.log(Level.CONFIG, "The delay / period for checking for artifact updates is {0} / {1} {2}.", new Object[]{tp.delay(), tp.period(), tp.unit().name().toLowerCase(Locale.ENGLISH)});
        try {
            this.context.start();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to start the update manager.", ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (null == this.context) {
            return;
        }
        try {
            this.context.stop(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to stop the update manager.", ex);
        }
    }
}

