/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.impl.javaee;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import net.java.trueupdate.manager.impl.javaee.UpdateManagerBean;
import net.java.trueupdate.manager.spec.UpdateMessage;

@MessageDriven(mappedName="jms/TrueUpdate Manager", activationConfig={@ActivationConfigProperty(propertyName="messageSelector", propertyValue="manager = true")})
@DependsOn(value={"UpdateManagerBean"})
public class UpdateManagerMessageListenerBean
implements MessageListener {
    private static final Logger logger = Logger.getLogger(UpdateManagerMessageListenerBean.class.getName());
    @EJB
    private UpdateManagerBean updateManager;
    @Resource
    private MessageDrivenContext context;

    public void onMessage(Message message) {
        logger.log(Level.FINEST, "Received JMS message for update manager: {0}", message);
        try {
            Serializable body;
            if (message instanceof ObjectMessage && (body = ((ObjectMessage)message).getObject()) instanceof UpdateMessage) {
                this.updateManager.onUpdateMessage((UpdateMessage)body);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.context.setRollbackOnly();
            logger.log(Level.SEVERE, "Could not process JMS message.", ex);
        }
    }
}

