/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.core.io.Copy;
import net.java.trueupdate.core.io.FileStore;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.jax.rs.client.UpdateClient;
import net.java.trueupdate.manager.core.FileAccount;
import net.java.trueupdate.manager.core.UpdateResolver;
import net.java.trueupdate.manager.spec.UpdateDescriptor;

abstract class BasicUpdateResolver
implements UpdateResolver {
    private static final Logger logger = Logger.getLogger(BasicUpdateResolver.class.getName());
    private final Map<UpdateDescriptor, FileAccount> accounts = new HashMap<UpdateDescriptor, FileAccount>();

    BasicUpdateResolver() {
    }

    abstract UpdateClient updateClient();

    final void restart() {
        for (FileAccount account : this.accounts.values()) {
            account.resetUsages();
        }
    }

    final void allocate(UpdateDescriptor descriptor) {
        this.account(descriptor).incrementUsagesAndGet();
    }

    private FileAccount account(UpdateDescriptor descriptor) {
        FileAccount account = this.accounts.get(descriptor);
        if (null == account) {
            account = new FileAccount();
            this.accounts.put(descriptor, account);
        }
        return account;
    }

    final void release(UpdateDescriptor descriptor) {
        FileAccount account = this.account(descriptor);
        int usages = account.decrementUsagesAndGet();
        if (0 >= usages) {
            assert (0 == usages);
            this.accounts.remove(descriptor);
            BasicUpdateResolver.deleteResolvedFile(account);
        }
    }

    @Override
    public final File resolveZipPatchFile(UpdateDescriptor descriptor) throws Exception {
        FileAccount account = this.account(descriptor);
        if (account.fileResolved()) {
            return account.file();
        }
        ArtifactDescriptor ad = descriptor.artifactDescriptor();
        String uv = descriptor.updateVersion();
        File patch = File.createTempFile("patch", ".zip");
        try {
            Copy.copy((Source)this.updateClient().diff(ad, uv), (Sink)new FileStore(patch));
        }
        catch (IOException ex) {
            patch.delete();
            throw ex;
        }
        logger.log(Level.INFO, "Downloaded ZIP patch file {0} for artifact descriptor {1} and update version {2} .", new Object[]{patch, ad, uv});
        account.file(patch);
        return patch;
    }

    final void shutdown() {
        Iterator<FileAccount> it = this.accounts.values().iterator();
        while (it.hasNext()) {
            BasicUpdateResolver.deleteResolvedFile(it.next());
            it.remove();
        }
    }

    private static void deleteResolvedFile(FileAccount account) {
        if (!account.fileResolved()) {
            return;
        }
        assert (0 <= account.usages());
        File file = account.file();
        if (file.delete()) {
            logger.log(Level.INFO, "Deleted ZIP patch file {0}.", file);
        } else {
            logger.log(Level.WARNING, "Could not delete ZIP patch file {0}.", file);
        }
    }
}

