/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.jax.rs.client.UpdateClient;
import net.java.trueupdate.manager.core.BasicUpdateResolver;
import net.java.trueupdate.manager.core.UpdateInstaller;
import net.java.trueupdate.manager.spec.ApplicationDescriptor;
import net.java.trueupdate.manager.spec.UpdateMessage;
import net.java.trueupdate.manager.spec.UpdateMessageListener;

@NotThreadSafe
public abstract class BasicUpdateManager
extends UpdateMessageListener {
    private static final Logger logger = Logger.getLogger(BasicUpdateManager.class.getName());
    private final Map<ApplicationDescriptor, UpdateMessage> subscriptions = new HashMap<ApplicationDescriptor, UpdateMessage>();
    private final BasicUpdateResolver updateResolver = new BasicUpdateResolver(){

        @Override
        protected UpdateClient updateClient() {
            return BasicUpdateManager.this.updateClient();
        }
    };

    protected abstract UpdateClient updateClient();

    protected abstract UpdateInstaller updateInstaller();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() throws Exception {
        try {
            this.updateResolver.shutdown();
        }
        finally {
            this.persistSubscriptions();
        }
    }

    private void persistSubscriptions() throws Exception {
        for (UpdateMessage subscription : this.subscriptions.values()) {
            this.send(subscription.type(UpdateMessage.Type.SUBSCRIPTION_NOTICE));
        }
    }

    protected void checkUpdates() throws Exception {
        if (this.subscriptions.isEmpty()) {
            return;
        }
        UpdateClient updateClient = this.updateClient();
        logger.log(Level.INFO, "Checking for artifact updates from {0} .", updateClient.baseUri());
        HashMap<ArtifactDescriptor, String> updateVersions = new HashMap<ArtifactDescriptor, String>();
        this.updateResolver.restart();
        try {
            for (UpdateMessage subscription : this.subscriptions.values()) {
                ArtifactDescriptor artifactDescriptor = subscription.artifactDescriptor();
                String updateVersion = (String)updateVersions.get(artifactDescriptor);
                if (null == updateVersion) {
                    updateVersion = updateClient.version(artifactDescriptor);
                    updateVersions.put(artifactDescriptor, updateVersion);
                }
                if (updateVersion.equals(artifactDescriptor.version())) continue;
                UpdateMessage un = BasicUpdateManager.updateNotice(subscription, updateVersion);
                this.updateResolver.allocate(un.updateDescriptor());
                this.sendAndLog(un);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Failed to resolve artifact update version:", ex);
        }
    }

    private static UpdateMessage updateNotice(UpdateMessage subscription, String updateVersion) {
        return subscription.successResponse().update().type(UpdateMessage.Type.UPDATE_NOTICE).updateVersion(updateVersion).build();
    }

    protected void onSubscriptionNotice(UpdateMessage message) throws Exception {
        this.subscribe(BasicUpdateManager.logReceived(message));
        this.checkUpdates();
    }

    protected void onSubscriptionRequest(UpdateMessage message) throws Exception {
        this.sendAndLog(this.subscribe(BasicUpdateManager.logReceived(message)));
        this.checkUpdates();
    }

    private UpdateMessage subscribe(UpdateMessage message) {
        this.subscriptions.put(message.applicationDescriptor(), message);
        return message.successResponse();
    }

    protected void onInstallationRequest(UpdateMessage message) throws Exception {
        this.sendAndLog(this.install(BasicUpdateManager.logReceived(message)));
    }

    private UpdateMessage install(UpdateMessage message) {
        try {
            this.updateInstaller().install(this.updateResolver, message);
            this.updateResolver.release(message.updateDescriptor());
            return BasicUpdateManager.installationSuccessResponse(message);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return message.failureResponse(ex);
        }
    }

    private static UpdateMessage installationSuccessResponse(UpdateMessage message) {
        return message.successResponse().update().artifactDescriptor(BasicUpdateManager.updatedArtifactDescriptor(message)).updateVersion(null).build();
    }

    private static ArtifactDescriptor updatedArtifactDescriptor(UpdateMessage message) {
        return message.artifactDescriptor().update().version(message.updateVersion()).build();
    }

    protected void onUnsubscriptionNotice(UpdateMessage message) throws Exception {
        this.unsubscribe(BasicUpdateManager.logReceived(message));
    }

    protected void onUnsubscriptionRequest(UpdateMessage message) throws Exception {
        this.sendAndLog(this.unsubscribe(BasicUpdateManager.logReceived(message)));
    }

    private UpdateMessage unsubscribe(UpdateMessage message) {
        this.subscriptions.remove(message.applicationDescriptor());
        return message.successResponse();
    }

    private UpdateMessage sendAndLog(UpdateMessage message) throws Exception {
        return BasicUpdateManager.logSent(this.send(message));
    }

    protected abstract UpdateMessage send(UpdateMessage var1) throws Exception;

    private static UpdateMessage logReceived(UpdateMessage message) {
        logger.log(Level.FINE, "Received update message from update agent:\n{0}", message);
        return message;
    }

    private static UpdateMessage logSent(UpdateMessage message) {
        logger.log(Level.FINER, "Sent update message to update agent:\n{0}", message);
        return message;
    }
}

