/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.installer.tomcat;

import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.java.trueupdate.installer.core.CoreUpdateInstaller;
import net.java.trueupdate.installer.core.UpdateParameters;
import net.java.trueupdate.installer.core.io.Files;
import net.java.trueupdate.manager.spec.UpdateContext;
import net.java.trueupdate.manager.spec.cmd.AbstractCommand;
import net.java.trueupdate.manager.spec.cmd.Command;
import net.java.trueupdate.manager.spec.cmd.Commands;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.ContextName;

@Immutable
public final class TomcatUpdateInstaller
extends CoreUpdateInstaller {
    private static final ObjectName PATTERN;
    private Host host;
    private HostConfig config;

    public TomcatUpdateInstaller() {
        for (MBeanServer mbs : MBeanServerFactory.findMBeanServer(null)) {
            for (ObjectName on : mbs.queryNames(PATTERN, null)) {
                try {
                    Engine engine = (Engine)mbs.getAttribute(on, "managedResource");
                    Host host = (Host)engine.findChild(engine.getDefaultHost());
                    if (null == host) continue;
                    this.host = host;
                    for (LifecycleListener listener : host.findLifecycleListeners()) {
                        if (!(listener instanceof HostConfig)) continue;
                        this.config = (HostConfig)listener;
                        return;
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                }
            }
        }
    }

    protected UpdateParameters updateParameters(final UpdateContext uc) throws Exception {
        if (null == this.host || null == this.config) {
            throw new Exception("The application is not running in Tomcat.");
        }
        class ResolvedParameters
        implements UpdateParameters {
            final File appBase;
            final ContextName ccn;
            final String cname;
            final File cdir;
            final File cwar;
            final boolean warDeployment;
            final ContextName ucn;
            final String uname;
            final File udir;
            final File uwar;

            ResolvedParameters() {
                this.appBase = TomcatUpdateInstaller.this.appBase();
                this.ccn = new ContextName(uc.currentLocation(), true);
                this.cname = this.ccn.getName();
                this.cdir = new File(this.appBase, this.ccn.getBaseName());
                this.cwar = new File(this.cdir.getPath() + ".war");
                this.warDeployment = this.cwar.isFile();
                this.ucn = new ContextName(uc.updateLocation(), true);
                this.uname = this.ucn.getName();
                this.udir = new File(this.appBase, this.ucn.getBaseName());
                this.uwar = new File(this.udir.getPath() + ".war");
            }

            public File currentPath() {
                return this.warDeployment ? this.cwar : this.cdir;
            }

            public Command undeploymentCommand() {
                class UndeploymentCommand
                extends AbstractCommand {
                    UndeploymentCommand() {
                    }

                    protected void doStart() throws Exception {
                        if (!TomcatUpdateInstaller.this.config.isDeployed(cname)) {
                            throw new Exception(String.format("The application %s is not deployed.", ccn.getDisplayName()));
                        }
                        TomcatUpdateInstaller.this.config.addServiced(cname);
                    }

                    protected void doPerform() throws Exception {
                        TomcatUpdateInstaller.this.config.unmanageApp(cname);
                        if (warDeployment) {
                            Files.deletePath((File)cdir);
                        }
                    }

                    protected void doRevert() throws Exception {
                        try {
                            TomcatUpdateInstaller.this.config.check(cname);
                        }
                        finally {
                            TomcatUpdateInstaller.this.config.removeServiced(cname);
                        }
                    }
                }
                return Commands.atomic((Command)new UndeploymentCommand());
            }

            public File updatePath() {
                return this.warDeployment ? this.uwar : this.udir;
            }

            public Command deploymentCommand() {
                class DeploymentCommand
                extends AbstractCommand {
                    DeploymentCommand() {
                    }

                    protected void doStart() throws Exception {
                        assert (!TomcatUpdateInstaller.this.config.isDeployed(uname));
                    }

                    protected void doPerform() throws Exception {
                        TomcatUpdateInstaller.this.config.check(uname);
                        TomcatUpdateInstaller.this.config.removeServiced(cname);
                    }

                    protected void doRevert() throws Exception {
                        TomcatUpdateInstaller.this.config.unmanageApp(uname);
                        if (warDeployment) {
                            Files.deletePath((File)udir);
                        }
                    }
                }
                return Commands.atomic((Command)new DeploymentCommand());
            }
        }
        return new ResolvedParameters();
    }

    File appBase() {
        File appBase = new File(this.host.getAppBase());
        if (!appBase.isAbsolute()) {
            File parent = new File(System.getProperty("catalina.base"));
            appBase = new File(parent, appBase.getPath());
        }
        try {
            return appBase.getCanonicalFile();
        }
        catch (IOException e) {
            return appBase;
        }
    }

    static {
        try {
            PATTERN = new ObjectName("*:type=Engine");
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

