/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.installer.openejb;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import javax.annotation.concurrent.Immutable;
import javax.ejb.EJB;
import net.java.trueupdate.installer.core.CoreUpdateInstaller;
import net.java.trueupdate.installer.core.UpdateParameters;
import net.java.trueupdate.manager.spec.UpdateContext;
import net.java.trueupdate.manager.spec.cmd.Command;
import net.java.trueupdate.manager.spec.cmd.Commands;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;

@Immutable
public final class OpenEjbUpdateInstaller
extends CoreUpdateInstaller {
    @EJB
    private Deployer deployer;

    protected UpdateParameters updateParameters(UpdateContext uc) throws Exception {
        final File cpath = this.resolveCurrentPath(new URI(uc.currentLocation()));
        final File upath = uc.updateLocation().equals(uc.currentLocation()) ? cpath : new File(uc.updateLocation());
        class ResolvedParameters
        implements UpdateParameters {
            ResolvedParameters() {
            }

            public File currentPath() {
                return cpath;
            }

            public Command undeploymentCommand() {
                class UndeploymentCommand
                implements Command {
                    UndeploymentCommand() {
                    }

                    public void perform() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.undeploy(cpath.getPath());
                    }

                    public void revert() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.deploy(cpath.getPath());
                    }
                }
                return Commands.atomic((Command)new UndeploymentCommand());
            }

            public File updatePath() {
                return upath;
            }

            public Command deploymentCommand() {
                class DeploymentCommand
                implements Command {
                    DeploymentCommand() {
                    }

                    public void perform() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.deploy(upath.getPath());
                    }

                    public void revert() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.undeploy(upath.getPath());
                    }
                }
                return Commands.atomic((Command)new DeploymentCommand());
            }
        }
        return new ResolvedParameters();
    }

    private File resolveCurrentPath(URI location) throws Exception {
        Scheme scheme = Scheme.valueOf(location.getScheme());
        for (AppInfo info : this.deployer.getDeployedApps()) {
            if (!scheme.matches(location, info)) continue;
            return new File(info.path);
        }
        throw new FileNotFoundException(String.format("Could not locate application at %s .", location));
    }

    private static enum Scheme {
        app{

            @Override
            boolean matches(URI location, AppInfo info) {
                return location.getSchemeSpecificPart().equals(info.appId);
            }
        }
        ,
        file{

            @Override
            boolean matches(URI location, AppInfo info) {
                return new File(location).equals(new File(info.path));
            }
        };


        abstract boolean matches(URI var1, AppInfo var2);
    }
}

