/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.installer.openejb;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import javax.annotation.concurrent.Immutable;
import javax.ejb.EJB;
import net.java.trueupdate.installer.core.LocalUpdateInstaller;
import net.java.trueupdate.manager.spec.UpdateContext;
import net.java.trueupdate.manager.spec.tx.AtomicMethodsTransaction;
import net.java.trueupdate.manager.spec.tx.Transaction;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;

@Immutable
public final class OpenEjbUpdateInstaller
extends LocalUpdateInstaller {
    @EJB
    private Deployer deployer;

    protected LocalUpdateInstaller.LocationContext locationContext(UpdateContext context, String location) throws Exception {
        final File path = location.equals(context.currentLocation()) ? this.resolveDeployedPath(new URI(location)) : new File(location);
        class ResolvedLocationContext
        implements LocalUpdateInstaller.LocationContext {
            ResolvedLocationContext() {
            }

            public File path() {
                return path;
            }

            public Transaction undeploymentTransaction() {
                class UndeploymentTransaction
                extends AtomicMethodsTransaction {
                    UndeploymentTransaction() {
                    }

                    public void performAtomic() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.undeploy(path.getPath());
                    }

                    public void rollbackAtomic() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.deploy(path.getPath());
                    }
                }
                return new UndeploymentTransaction();
            }

            public Transaction deploymentTransaction() {
                class DeploymentTransaction
                extends AtomicMethodsTransaction {
                    DeploymentTransaction() {
                    }

                    public void performAtomic() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.deploy(path.getPath());
                    }

                    public void rollbackAtomic() throws Exception {
                        OpenEjbUpdateInstaller.this.deployer.undeploy(path.getPath());
                    }
                }
                return new DeploymentTransaction();
            }
        }
        return new ResolvedLocationContext();
    }

    private File resolveDeployedPath(URI location) throws Exception {
        Scheme scheme = Scheme.valueOf(location.getScheme());
        for (AppInfo info : this.deployer.getDeployedApps()) {
            if (!scheme.matches(location, info)) continue;
            return new File(info.path);
        }
        throw new FileNotFoundException(String.format("Cannot locate application at %s .", location));
    }

    private static enum Scheme {
        app{

            @Override
            boolean matches(URI location, AppInfo info) {
                return location.getSchemeSpecificPart().equals(info.appId);
            }
        }
        ,
        file{

            @Override
            boolean matches(URI location, AppInfo info) {
                return new File(location).equals(new File(info.path));
            }
        };


        abstract boolean matches(URI var1, AppInfo var2);
    }
}

