/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.model;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.trueupdate.core.io.InputTask;
import net.java.trueupdate.core.io.MessageDigests;
import net.java.trueupdate.core.io.OutputTask;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.Sinks;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.Sources;
import net.java.trueupdate.core.zip.model.EntryNameAndDigest;
import net.java.trueupdate.core.zip.model.EntryNameAndDigestMapAdapter;
import net.java.trueupdate.core.zip.model.EntryNameAndTwoDigests;
import net.java.trueupdate.core.zip.model.EntryNameAndTwoDigestsMapAdapter;
import net.java.trueupdate.util.HashMaps;
import net.java.trueupdate.util.Objects;

@XmlRootElement(name="delta")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Immutable
public final class DeltaModel
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String ENTRY_NAME = "META-INF/delta.xml";
    @XmlAttribute(required=true)
    private final String algorithm;
    @XmlAttribute
    @CheckForNull
    private final Integer numBytes;
    @XmlJavaTypeAdapter(value=EntryNameAndTwoDigestsMapAdapter.class)
    private final Map<String, EntryNameAndTwoDigests> changed;
    @XmlJavaTypeAdapter(value=EntryNameAndDigestMapAdapter.class)
    private final Map<String, EntryNameAndDigest> unchanged;
    @XmlJavaTypeAdapter(value=EntryNameAndDigestMapAdapter.class)
    private final Map<String, EntryNameAndDigest> added;
    @XmlJavaTypeAdapter(value=EntryNameAndDigestMapAdapter.class)
    private final Map<String, EntryNameAndDigest> removed;

    private DeltaModel() {
        this.algorithm = "";
        this.numBytes = null;
        this.changed = Collections.emptyMap();
        this.removed = Collections.emptyMap();
        this.added = this.removed;
        this.unchanged = this.removed;
    }

    DeltaModel(Builder b) {
        this.algorithm = b.messageDigest.getAlgorithm();
        this.numBytes = DeltaModel.lengthBytes(b.messageDigest);
        this.changed = DeltaModel.changedMap(b.changed);
        this.unchanged = DeltaModel.unchangedMap(b.unchanged);
        this.added = DeltaModel.unchangedMap(b.added);
        this.removed = DeltaModel.unchangedMap(b.removed);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    private static Integer lengthBytes(MessageDigest digest) {
        try {
            MessageDigest clone = MessageDigests.create(digest.getAlgorithm());
            if (clone.getDigestLength() == digest.getDigestLength()) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return digest.getDigestLength();
    }

    static Map<String, EntryNameAndTwoDigests> changedMap(Collection<EntryNameAndTwoDigests> entries) {
        LinkedHashMap<String, EntryNameAndTwoDigests> map = new LinkedHashMap<String, EntryNameAndTwoDigests>(DeltaModel.initialCapacity(entries));
        for (EntryNameAndTwoDigests entryNameAndTwoDigests : entries) {
            map.put(entryNameAndTwoDigests.name(), entryNameAndTwoDigests);
        }
        return Collections.unmodifiableMap(map);
    }

    static Map<String, EntryNameAndDigest> unchangedMap(Collection<EntryNameAndDigest> entries) {
        LinkedHashMap<String, EntryNameAndDigest> map = new LinkedHashMap<String, EntryNameAndDigest>(DeltaModel.initialCapacity(entries));
        for (EntryNameAndDigest entryNameAndDigest : entries) {
            map.put(entryNameAndDigest.name(), entryNameAndDigest);
        }
        return Collections.unmodifiableMap(map);
    }

    private static int initialCapacity(Collection<?> c) {
        return HashMaps.initialCapacity((int)c.size());
    }

    public String digestAlgorithmName() {
        return this.algorithm;
    }

    @Nullable
    public Integer digestByteLength() {
        return this.numBytes;
    }

    public Collection<EntryNameAndTwoDigests> changedEntries() {
        return this.changed.values();
    }

    public EntryNameAndTwoDigests changed(String name) {
        return this.changed.get(name);
    }

    public Collection<EntryNameAndDigest> unchangedEntries() {
        return this.unchanged.values();
    }

    @Deprecated
    public EntryNameAndDigest unchanged(String name) {
        return this.unchanged.get(name);
    }

    public Collection<EntryNameAndDigest> addedEntries() {
        return this.added.values();
    }

    public EntryNameAndDigest added(String name) {
        return this.added.get(name);
    }

    public Collection<EntryNameAndDigest> removedEntries() {
        return this.removed.values();
    }

    @Deprecated
    public EntryNameAndDigest removed(String name) {
        return this.removed.get(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeltaModel)) {
            return false;
        }
        DeltaModel that = (DeltaModel)obj;
        return this.algorithm.equals(that.algorithm) && Objects.equals((Object)this.numBytes, (Object)that.numBytes) && ((Object)this.changed).equals(that.changed) && ((Object)this.unchanged).equals(that.unchanged) && ((Object)this.added).equals(that.added) && ((Object)this.removed).equals(that.removed);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.algorithm.hashCode();
        hash = 31 * hash + Objects.hashCode((Object)this.numBytes);
        hash = 31 * hash + ((Object)this.changed).hashCode();
        hash = 31 * hash + ((Object)this.unchanged).hashCode();
        hash = 31 * hash + ((Object)this.added).hashCode();
        hash = 31 * hash + ((Object)this.removed).hashCode();
        return hash;
    }

    public void encodeToXml(Sink sink) throws Exception {
        class EncodeTask
        implements OutputTask<Void, JAXBException> {
            EncodeTask() {
            }

            @Override
            public Void execute(OutputStream out) throws JAXBException {
                DeltaModel.jaxbContext().createMarshaller().marshal((Object)DeltaModel.this, out);
                return null;
            }
        }
        Sinks.execute(new EncodeTask()).on(sink);
    }

    public static DeltaModel decodeFromXml(Source source) throws Exception {
        class DecodeTask
        implements InputTask<DeltaModel, JAXBException> {
            DecodeTask() {
            }

            @Override
            public DeltaModel execute(InputStream in) throws JAXBException {
                return (DeltaModel)DeltaModel.jaxbContext().createUnmarshaller().unmarshal(in);
            }
        }
        return Sources.execute(new DecodeTask()).on(source);
    }

    public static JAXBContext jaxbContext() {
        return Lazy.JAXB_CONTEXT;
    }

    public static final class Builder {
        @CheckForNull
        MessageDigest messageDigest;
        @CheckForNull
        Collection<EntryNameAndTwoDigests> changed = Collections.emptyList();
        @CheckForNull
        Collection<EntryNameAndDigest> unchanged = Collections.emptyList();
        @CheckForNull
        Collection<EntryNameAndDigest> added = Collections.emptyList();
        @CheckForNull
        Collection<EntryNameAndDigest> removed = Collections.emptyList();

        Builder() {
        }

        public Builder messageDigest(@Nullable MessageDigest messageDigest) {
            this.messageDigest = messageDigest;
            return this;
        }

        public Builder changedEntries(@Nullable Collection<EntryNameAndTwoDigests> changed) {
            this.changed = changed;
            return this;
        }

        public Builder unchangedEntries(@Nullable Collection<EntryNameAndDigest> unchanged) {
            this.unchanged = unchanged;
            return this;
        }

        public Builder addedEntries(@Nullable Collection<EntryNameAndDigest> added) {
            this.added = added;
            return this;
        }

        public Builder removedEntries(@Nullable Collection<EntryNameAndDigest> removed) {
            this.removed = removed;
            return this;
        }

        public DeltaModel build() {
            return new DeltaModel(this);
        }
    }

    private static class Lazy {
        static final JAXBContext JAXB_CONTEXT;

        private Lazy() {
        }

        static {
            try {
                JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{DeltaModel.class});
            }
            catch (JAXBException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }
}

