/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.diff;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.io.MessageDigests;
import net.java.trueupdate.core.zip.diff.RawZipDiff;
import net.java.trueupdate.core.zip.io.ZipFileStore;
import net.java.trueupdate.core.zip.io.ZipInput;
import net.java.trueupdate.core.zip.io.ZipInputTask;
import net.java.trueupdate.core.zip.io.ZipOutput;
import net.java.trueupdate.core.zip.io.ZipOutputTask;
import net.java.trueupdate.core.zip.io.ZipSink;
import net.java.trueupdate.core.zip.io.ZipSinks;
import net.java.trueupdate.core.zip.io.ZipSource;
import net.java.trueupdate.core.zip.io.ZipSources;
import net.java.trueupdate.util.Objects;

@Immutable
public abstract class ZipDiff {
    public static Builder builder() {
        return new Builder();
    }

    public abstract void output(File var1) throws IOException;

    public abstract void output(ZipSink var1) throws IOException;

    public static class Builder {
        @CheckForNull
        private ZipSource input1;
        @CheckForNull
        private ZipSource input2;
        @CheckForNull
        private String digest;

        Builder() {
        }

        public Builder input1(@CheckForNull File input1) {
            return this.input1(null == input1 ? null : new ZipFileStore(input1));
        }

        public Builder input1(@Nullable ZipSource input1) {
            this.input1 = input1;
            return this;
        }

        public Builder input2(@CheckForNull File input2) {
            return this.input2(null == input2 ? null : new ZipFileStore(input2));
        }

        public Builder input2(@Nullable ZipSource input2) {
            this.input2 = input2;
            return this;
        }

        public Builder digest(@Nullable String digest) {
            this.digest = digest;
            return this;
        }

        public ZipDiff build() {
            return Builder.create(this.input1, this.input2, this.digest);
        }

        @CreatesObligation
        private static ZipDiff create(final ZipSource input1, final ZipSource input2, final @CheckForNull String digestName) {
            Objects.requireNonNull((Object)input1);
            Objects.requireNonNull((Object)input2);
            return new ZipDiff(){

                @Override
                public void output(File file) throws IOException {
                    this.output(new ZipFileStore(file));
                }

                @Override
                public void output(final ZipSink sink) throws IOException {
                    class Input1Task
                    implements ZipInputTask<Void, IOException> {
                        Input1Task() {
                        }

                        @Override
                        public Void execute(final ZipInput input1) throws IOException {
                            class Input2Task
                            implements ZipInputTask<Void, IOException> {
                                Input2Task() {
                                }

                                @Override
                                public Void execute(final ZipInput input2) throws IOException {
                                    class DiffTask
                                    implements ZipOutputTask<Void, IOException> {
                                        DiffTask() {
                                        }

                                        @Override
                                        public Void execute(ZipOutput delta) throws IOException {
                                            new RawZipDiff(){
                                                final MessageDigest digest;
                                                {
                                                    this.digest = MessageDigests.create(null != digestName ? digestName : "SHA-1");
                                                }

                                                @Override
                                                protected MessageDigest digest() {
                                                    return this.digest;
                                                }

                                                @Override
                                                protected ZipInput input1() {
                                                    return input1;
                                                }

                                                @Override
                                                protected ZipInput input2() {
                                                    return input2;
                                                }
                                            }.output(delta);
                                            return null;
                                        }
                                    }
                                    return ZipSinks.execute(new DiffTask()).on(sink);
                                }
                            }
                            return ZipSources.execute(new Input2Task()).on(input2);
                        }
                    }
                    ZipSources.execute(new Input1Task()).on(input1);
                }
            };
        }
    }
}

