/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.diff;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.io.Copy;
import net.java.trueupdate.core.io.MessageDigests;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.zip.io.ZipEntrySink;
import net.java.trueupdate.core.zip.io.ZipEntrySource;
import net.java.trueupdate.core.zip.io.ZipInput;
import net.java.trueupdate.core.zip.io.ZipOutput;
import net.java.trueupdate.core.zip.model.DeltaModel;
import net.java.trueupdate.core.zip.model.EntryNameAndDigest;
import net.java.trueupdate.core.zip.model.EntryNameAndTwoDigests;

@Immutable
public abstract class RawZipDiff {
    private static final Pattern COMPRESSED_FILE_EXTENSIONS = Pattern.compile(".*\\.(ear|jar|war|zip|gz|xz)", 2);

    protected abstract MessageDigest digest();

    @WillNotClose
    protected abstract ZipInput input1();

    @WillNotClose
    protected abstract ZipInput input2();

    public void output(final @WillNotClose ZipOutput delta) throws IOException {
        final class Streamer {
            final DeltaModel model;

            Streamer() throws IOException {
                this.model = RawZipDiff.this.model();
                try {
                    this.model.encodeToXml(this.sink(this.entry("META-INF/delta.xml")));
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }

            Streamer stream() throws IOException {
                for (ZipEntry in : RawZipDiff.this.input2()) {
                    String name = in.getName();
                    if (!this.changedOrAdded(name)) continue;
                    ZipEntry out = this.entry(name);
                    if (COMPRESSED_FILE_EXTENSIONS.matcher(name).matches()) {
                        long size = in.getSize();
                        out.setMethod(0);
                        out.setSize(size);
                        out.setCompressedSize(size);
                        out.setCrc(in.getCrc());
                    }
                    Copy.copy(this.source2(in), this.sink(out));
                }
                return this;
            }

            Source source2(ZipEntry entry) {
                return new ZipEntrySource(entry, RawZipDiff.this.input2());
            }

            Sink sink(ZipEntry entry) {
                return new ZipEntrySink(entry, delta);
            }

            ZipEntry entry(String name) {
                return delta.entry(name);
            }

            boolean changedOrAdded(String name) {
                return null != this.model.changed(name) || null != this.model.added(name);
            }
        }
        new Streamer().stream();
    }

    public DeltaModel model() throws IOException {
        return new Assembler().walkAndReturn(new Assembly()).buildZipDiffModel();
    }

    private static interface Visitor {
        public void visitEntryInFirstFile(ZipEntrySource var1) throws IOException;

        public void visitEntryInSecondFile(ZipEntrySource var1) throws IOException;

        public void visitEntriesInBothFiles(ZipEntrySource var1, ZipEntrySource var2) throws IOException;
    }

    private class Assembly
    implements Visitor {
        private final Map<String, EntryNameAndTwoDigests> changed = new TreeMap<String, EntryNameAndTwoDigests>();
        private final Map<String, EntryNameAndDigest> unchanged = new TreeMap<String, EntryNameAndDigest>();
        private final Map<String, EntryNameAndDigest> added = new TreeMap<String, EntryNameAndDigest>();
        private final Map<String, EntryNameAndDigest> removed = new TreeMap<String, EntryNameAndDigest>();

        private Assembly() {
        }

        DeltaModel buildZipDiffModel() {
            return DeltaModel.builder().messageDigest(RawZipDiff.this.digest()).changedEntries(this.changed.values()).unchangedEntries(this.unchanged.values()).addedEntries(this.added.values()).removedEntries(this.removed.values()).build();
        }

        @Override
        public void visitEntriesInBothFiles(ZipEntrySource source1, ZipEntrySource source2) throws IOException {
            String digest2;
            String name1 = source1.name();
            assert (name1.equals(source2.name()));
            String digest1 = this.digestValueOf(source1);
            if (digest1.equals(digest2 = this.digestValueOf(source2))) {
                this.unchanged.put(name1, new EntryNameAndDigest(name1, digest1));
            } else {
                this.changed.put(name1, new EntryNameAndTwoDigests(name1, digest1, digest2));
            }
        }

        @Override
        public void visitEntryInFirstFile(ZipEntrySource source1) throws IOException {
            String name = source1.name();
            this.removed.put(name, new EntryNameAndDigest(name, this.digestValueOf(source1)));
        }

        @Override
        public void visitEntryInSecondFile(ZipEntrySource source2) throws IOException {
            String name = source2.name();
            this.added.put(name, new EntryNameAndDigest(name, this.digestValueOf(source2)));
        }

        String digestValueOf(Source source) throws IOException {
            MessageDigest digest = RawZipDiff.this.digest();
            digest.reset();
            MessageDigests.updateDigestFrom(digest, source);
            return MessageDigests.valueOf(digest);
        }
    }

    @Immutable
    private class Assembler {
        private Assembler() {
        }

        <V extends Visitor> V walkAndReturn(V visitor) throws IOException {
            for (ZipEntry entry1 : RawZipDiff.this.input1()) {
                if (entry1.isDirectory()) continue;
                ZipEntry entry2 = RawZipDiff.this.input2().entry(entry1.getName());
                ZipEntrySource source1 = new ZipEntrySource(entry1, RawZipDiff.this.input1());
                if (null == entry2) {
                    visitor.visitEntryInFirstFile(source1);
                    continue;
                }
                visitor.visitEntriesInBothFiles(source1, new ZipEntrySource(entry2, RawZipDiff.this.input2()));
            }
            for (ZipEntry entry2 : RawZipDiff.this.input2()) {
                ZipEntry entry1;
                if (entry2.isDirectory() || null != (entry1 = RawZipDiff.this.input1().entry(entry2.getName()))) continue;
                visitor.visitEntryInSecondFile(new ZipEntrySource(entry2, RawZipDiff.this.input2()));
            }
            return visitor;
        }
    }
}

