/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.codec;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.java.trueupdate.core.codec.Codec;
import net.java.trueupdate.core.io.InputTask;
import net.java.trueupdate.core.io.OutputTask;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.Sinks;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.Sources;
import net.java.trueupdate.util.Objects;

@Immutable
public class JaxbCodec
implements Codec {
    protected final JAXBContext context;

    public JaxbCodec(JAXBContext context) {
        this.context = (JAXBContext)Objects.requireNonNull((Object)context);
    }

    @Override
    public String contentType() {
        return "application/xml; charset=utf-8";
    }

    @Override
    public String contentTransferEncoding() {
        return "8bit";
    }

    @Override
    public void encode(Sink sink, final Object obj) throws Exception {
        class EncodeTask
        implements OutputTask<Void, JAXBException> {
            EncodeTask() {
            }

            public Void execute(OutputStream out) throws JAXBException {
                JaxbCodec.this.marshaller().marshal(obj, out);
                return null;
            }
        }
        Sinks.execute((OutputTask)new EncodeTask()).on(sink);
    }

    protected Marshaller marshaller() throws JAXBException {
        return this.context.createMarshaller();
    }

    @Override
    public <T> T decode(Source source, Type expected) throws Exception {
        class DecodeTask
        implements InputTask<T, JAXBException> {
            DecodeTask() {
            }

            public T execute(InputStream in) throws JAXBException {
                return JaxbCodec.this.unmarshaller().unmarshal(in);
            }
        }
        return (T)Sources.execute((InputTask)new DecodeTask()).on(source);
    }

    protected Unmarshaller unmarshaller() throws JAXBException {
        return this.context.createUnmarshaller();
    }
}

