/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.patch;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.ThreadSafe;
import net.java.trueupdate.core.io.Copy;
import net.java.trueupdate.core.io.MessageDigests;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.zip.io.ZipEntrySource;
import net.java.trueupdate.core.zip.io.ZipInput;
import net.java.trueupdate.core.zip.io.ZipOutput;
import net.java.trueupdate.core.zip.model.DiffModel;
import net.java.trueupdate.core.zip.model.EntryNameAndDigest;
import net.java.trueupdate.core.zip.patch.AcceptAllEntryNameFilter;
import net.java.trueupdate.core.zip.patch.EntryNameAndDigest2Transformation;
import net.java.trueupdate.core.zip.patch.EntryNameFilter;
import net.java.trueupdate.core.zip.patch.IdentityTransformation;
import net.java.trueupdate.core.zip.patch.InvalidDiffZipFileException;
import net.java.trueupdate.core.zip.patch.InverseEntryNameFilter;
import net.java.trueupdate.core.zip.patch.ManifestEntryNameFilter;
import net.java.trueupdate.core.zip.patch.MissingZipEntryException;
import net.java.trueupdate.core.zip.patch.NoDirectoryEntryNameFilter;
import net.java.trueupdate.core.zip.patch.Transformation;
import net.java.trueupdate.core.zip.patch.WrongInputZipFile;
import net.java.trueupdate.core.zip.patch.WrongMessageDigestException;

@ThreadSafe
public abstract class RawZipPatch {
    private volatile DiffModel model;

    @WillNotClose
    protected abstract ZipInput input();

    @WillNotClose
    protected abstract ZipInput diff();

    public void output(@WillNotClose ZipOutput output) throws IOException {
        for (EntryNameFilter filter : this.passFilters(output)) {
            this.output(output, new NoDirectoryEntryNameFilter(filter));
        }
    }

    private EntryNameFilter[] passFilters(@WillNotClose ZipOutput output) {
        if (output.entry("") instanceof JarEntry) {
            ManifestEntryNameFilter manifestFilter = new ManifestEntryNameFilter();
            return new EntryNameFilter[]{manifestFilter, new InverseEntryNameFilter(manifestFilter)};
        }
        return new EntryNameFilter[]{new AcceptAllEntryNameFilter()};
    }

    private void output(final @WillNotClose ZipOutput output, final EntryNameFilter filter) throws IOException {
        abstract class PatchSet {
            final /* synthetic */ EntryNameFilter val$filter;
            final /* synthetic */ ZipOutput val$output;

            PatchSet() {
                this.val$filter = entryNameFilter;
                this.val$output = zipOutput;
            }

            abstract ZipInput archive();

            abstract IOException ioException(Throwable var1);

            final <T> PatchSet apply(Transformation<T> transformation, Iterable<T> iterable) throws IOException {
                for (T item : iterable) {
                    EntryNameAndDigest entryNameAndDigest = transformation.apply(item);
                    String name = entryNameAndDigest.name();
                    if (!this.val$filter.accept(name)) continue;
                    ZipEntry entry = this.archive().entry(name);
                    if (null == entry) {
                        throw this.ioException(new MissingZipEntryException(name));
                    }
                    try {
                        class ZipEntrySink
                        implements Sink {
                            final EntryNameAndDigest entryNameAndDigest;
                            final /* synthetic */ ZipOutput val$output;

                            ZipEntrySink(EntryNameAndDigest entryNameAndDigest) {
                                this.val$output = zipOutput;
                                assert (null != entryNameAndDigest);
                                this.entryNameAndDigest = entryNameAndDigest;
                            }

                            @Override
                            public OutputStream output() throws IOException {
                                ZipEntry entry = this.entry(this.entryNameAndDigest.name());
                                if (entry.isDirectory()) {
                                    entry.setMethod(0);
                                    entry.setSize(0L);
                                    entry.setCompressedSize(0L);
                                    entry.setCrc(0L);
                                }
                                MessageDigest digest = RawZipPatch.this.digest();
                                digest.reset();
                                return new DigestOutputStream(this.stream(entry), digest){

                                    @Override
                                    public void close() throws IOException {
                                        super.close();
                                        if (!this.valueOfDigest().equals(entryNameAndDigest.digest())) {
                                            throw new WrongMessageDigestException(entryNameAndDigest.name());
                                        }
                                    }

                                    String valueOfDigest() {
                                        return MessageDigests.valueOf(this.digest);
                                    }
                                };
                            }

                            OutputStream stream(ZipEntry entry) throws IOException {
                                return this.val$output.stream(entry);
                            }

                            ZipEntry entry(String name) {
                                return this.val$output.entry(name);
                            }
                        }
                        Copy.copy(new ZipEntrySource(entry, this.archive()), new ZipEntrySink(RawZipPatch.this, entryNameAndDigest, this.val$output));
                    }
                    catch (WrongMessageDigestException ex) {
                        throw this.ioException(ex);
                    }
                }
                return this;
            }
        }
        class InputArchivePatchSet
        extends PatchSet {
            InputArchivePatchSet() {
                super(RawZipPatch.this, entryNameFilter, zipOutput);
            }

            @Override
            ZipInput archive() {
                return RawZipPatch.this.input();
            }

            @Override
            IOException ioException(Throwable cause) {
                return new WrongInputZipFile(cause);
            }
        }
        new InputArchivePatchSet().apply(new IdentityTransformation(), this.model().unchangedEntries());
        class PatchArchivePatchSet
        extends PatchSet {
            PatchArchivePatchSet() {
                super(RawZipPatch.this, entryNameFilter, zipOutput);
            }

            @Override
            ZipInput archive() {
                return RawZipPatch.this.diff();
            }

            @Override
            IOException ioException(Throwable cause) {
                return new InvalidDiffZipFileException(cause);
            }
        }
        new PatchArchivePatchSet().apply(new EntryNameAndDigest2Transformation(), this.model().changedEntries());
        new PatchArchivePatchSet().apply(new IdentityTransformation(), this.model().addedEntries());
    }

    private MessageDigest digest() throws IOException {
        return MessageDigests.create(this.model().digestAlgorithmName());
    }

    private DiffModel model() throws IOException {
        DiffModel model = this.model;
        return null != model ? model : (this.model = this.loadModel());
    }

    private DiffModel loadModel() throws IOException {
        try {
            return DiffModel.decodeFromXml(new ZipEntrySource(this.modelZipEntry(), this.diff()));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidDiffZipFileException(ex);
        }
    }

    private ZipEntry modelZipEntry() throws IOException {
        String name = "META-INF/diff.xml";
        ZipEntry entry = this.diff().entry("META-INF/diff.xml");
        if (null == entry) {
            throw new InvalidDiffZipFileException(new MissingZipEntryException("META-INF/diff.xml"));
        }
        return entry;
    }
}

