/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.java.trueupdate.core.zip.io.ZipFileAdapter;
import net.java.trueupdate.core.zip.io.ZipInput;
import net.java.trueupdate.core.zip.io.ZipOutput;
import net.java.trueupdate.core.zip.io.ZipOutputStreamAdapter;
import net.java.trueupdate.core.zip.io.ZipStore;
import net.java.trueupdate.util.Objects;

public class ZipFileStore
implements ZipStore {
    final File file;

    public ZipFileStore(File file) {
        this.file = (File)Objects.requireNonNull((Object)file);
    }

    @Override
    public ZipInput input() throws IOException {
        return new ZipFileAdapter(new ZipFile(this.file));
    }

    @Override
    public ZipOutput output() throws IOException {
        return new ZipOutputStreamAdapter(new ZipOutputStream(new FileOutputStream(this.file)));
    }

    @Override
    public void delete() throws IOException {
        if (!this.file.delete()) {
            throw new FileNotFoundException(this.file + " (cannot delete)");
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }
}

