/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import net.java.trueupdate.core.zip.io.ZipInput;
import net.java.trueupdate.util.Objects;

public class ZipFileAdapter
implements ZipInput {
    protected ZipFile zip;

    protected ZipFileAdapter() {
    }

    public ZipFileAdapter(@WillCloseWhenClosed ZipFile input) {
        this.zip = (ZipFile)Objects.requireNonNull((Object)input);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new Iterator<ZipEntry>(){
            final Enumeration<? extends ZipEntry> en;
            {
                this.en = ZipFileAdapter.this.zip.entries();
            }

            @Override
            public boolean hasNext() {
                return this.en.hasMoreElements();
            }

            @Override
            public ZipEntry next() {
                return this.en.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    @Nullable
    public ZipEntry entry(String name) {
        return this.zip.getEntry(name);
    }

    @Override
    public InputStream stream(ZipEntry entry) throws IOException {
        return this.zip.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }
}

