/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.zip.io.ZipOutput;
import net.java.trueupdate.util.Objects;

public final class ZipEntrySink
implements Sink {
    private final ZipEntry entry;
    private final ZipOutput output;

    public ZipEntrySink(ZipEntry entry, ZipOutput output) {
        this.entry = (ZipEntry)Objects.requireNonNull((Object)entry);
        this.output = (ZipOutput)Objects.requireNonNull((Object)output);
    }

    public String name() {
        return this.entry.getName();
    }

    public boolean directory() {
        return this.entry.isDirectory();
    }

    @Override
    public OutputStream output() throws IOException {
        if (this.directory()) {
            this.entry.setMethod(0);
            this.entry.setSize(0L);
            this.entry.setCompressedSize(0L);
            this.entry.setCrc(0L);
        }
        return this.output.stream(this.entry);
    }
}

