/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.trueupdate.core.io.Store;

public final class MemoryStore
implements Store {
    private final int bufsize;
    private byte[] buffer;

    public MemoryStore() {
        this(8192);
    }

    public MemoryStore(int bufsize) {
        this.bufsize = bufsize;
        if (0 > this.bufsize) {
            throw new IllegalArgumentException();
        }
    }

    private static byte[] clone(@CheckForNull byte[] buffer) {
        return null == buffer ? null : (byte[])buffer.clone();
    }

    private byte[] checkedData() throws FileNotFoundException {
        if (null == this.buffer) {
            throw new FileNotFoundException();
        }
        return this.buffer;
    }

    @Nullable
    public byte[] data() {
        return MemoryStore.clone(this.buffer);
    }

    public void data(@CheckForNull byte[] buffer) {
        this.buffer = MemoryStore.clone(buffer);
    }

    public InputStream input() throws IOException {
        return new ByteArrayInputStream(this.checkedData());
    }

    public OutputStream output() throws IOException {
        return new ByteArrayOutputStream(this.bufsize){

            @Override
            public void close() throws IOException {
                MemoryStore.access$002(MemoryStore.this, this.toByteArray());
            }
        };
    }

    public void delete() throws IOException {
        this.checkedData();
        this.buffer = null;
    }

    public boolean exists() {
        return null != this.buffer;
    }

    static /* synthetic */ byte[] access$002(MemoryStore x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }
}

