/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.patch;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.zip.io.ZipFileStore;
import net.java.trueupdate.core.zip.io.ZipInput;
import net.java.trueupdate.core.zip.io.ZipInputTask;
import net.java.trueupdate.core.zip.io.ZipOutput;
import net.java.trueupdate.core.zip.io.ZipOutputTask;
import net.java.trueupdate.core.zip.io.ZipSink;
import net.java.trueupdate.core.zip.io.ZipSinks;
import net.java.trueupdate.core.zip.io.ZipSource;
import net.java.trueupdate.core.zip.io.ZipSources;
import net.java.trueupdate.core.zip.patch.RawZipPatch;
import net.java.trueupdate.util.Objects;

@Immutable
public abstract class ZipPatch {
    public static Builder builder() {
        return new Builder();
    }

    public abstract void output(File var1) throws IOException;

    public abstract void output(ZipSink var1) throws IOException;

    public static class Builder {
        @CheckForNull
        private ZipSource input;
        @CheckForNull
        private ZipSource diff;

        Builder() {
        }

        public Builder input(@Nullable File file) {
            return this.input(null == file ? null : new ZipFileStore(file));
        }

        public Builder input(@Nullable ZipSource input) {
            this.input = input;
            return this;
        }

        public Builder diff(@Nullable File file) {
            return this.diff(null == file ? null : new ZipFileStore(file));
        }

        public Builder diff(@Nullable ZipSource diff) {
            this.diff = diff;
            return this;
        }

        public ZipPatch build() {
            return Builder.create(this.input, this.diff);
        }

        private static ZipPatch create(final ZipSource input, final ZipSource diff) {
            Objects.requireNonNull((Object)input);
            Objects.requireNonNull((Object)diff);
            return new ZipPatch(){

                @Override
                public void output(File file) throws IOException {
                    this.output(new ZipFileStore(file));
                }

                @Override
                public void output(final ZipSink sink) throws IOException {
                    class InputTask
                    implements ZipInputTask<Void, IOException> {
                        InputTask() {
                        }

                        @Override
                        public Void execute(final @WillNotClose ZipInput input) throws IOException {
                            class DiffTask
                            implements ZipInputTask<Void, IOException> {
                                DiffTask() {
                                }

                                @Override
                                public Void execute(final @WillNotClose ZipInput diff) throws IOException {
                                    class OutputTask
                                    implements ZipOutputTask<Void, IOException> {
                                        OutputTask() {
                                        }

                                        @Override
                                        public Void execute(@WillNotClose ZipOutput output) throws IOException {
                                            new RawZipPatch(){

                                                @Override
                                                protected ZipInput input() {
                                                    return input;
                                                }

                                                @Override
                                                protected ZipInput diff() {
                                                    return diff;
                                                }
                                            }.output(output);
                                            return null;
                                        }
                                    }
                                    return ZipSinks.execute(new OutputTask()).on(sink);
                                }
                            }
                            return ZipSources.execute(new DiffTask()).on(diff);
                        }
                    }
                    ZipSources.execute(new InputTask()).on(input);
                }
            };
        }
    }
}

