/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.WillCloseWhenClosed;
import net.java.trueupdate.core.zip.io.ZipOutput;
import net.java.trueupdate.util.Objects;

public class ZipOutputStreamAdapter
implements ZipOutput {
    protected ZipOutputStream zip;

    protected ZipOutputStreamAdapter() {
    }

    public ZipOutputStreamAdapter(@WillCloseWhenClosed ZipOutputStream zip) {
        this.zip = (ZipOutputStream)Objects.requireNonNull((Object)zip);
    }

    @Override
    public ZipEntry entry(String name) {
        return new ZipEntry(name);
    }

    @Override
    public OutputStream stream(ZipEntry entry) throws IOException {
        this.zip.putNextEntry(entry);
        return new FilterOutputStream(this.zip){

            @Override
            public void close() throws IOException {
                ((ZipOutputStream)this.out).closeEntry();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }
}

