/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.zip.io.ZipInput;
import net.java.trueupdate.util.Objects;

public final class ZipEntrySource
implements Source {
    private final ZipEntry entry;
    private final ZipInput input;

    public ZipEntrySource(ZipEntry entry, ZipInput input) {
        this.entry = (ZipEntry)Objects.requireNonNull((Object)entry);
        this.input = (ZipInput)Objects.requireNonNull((Object)input);
    }

    public String name() {
        return this.entry.getName();
    }

    public boolean directory() {
        return this.entry.isDirectory();
    }

    @Override
    public InputStream input() throws IOException {
        return this.input.stream(this.entry);
    }
}

