/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.patch;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.trueupdate.core.io.Copy;
import net.java.trueupdate.core.io.MessageDigests;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.ZipEntrySource;
import net.java.trueupdate.core.io.ZipOutputTask;
import net.java.trueupdate.core.io.ZipSinks;
import net.java.trueupdate.core.zip.model.DiffModel;
import net.java.trueupdate.core.zip.model.EntryNameAndDigest;
import net.java.trueupdate.core.zip.patch.AcceptAllEntryNameFilter;
import net.java.trueupdate.core.zip.patch.EntryNameAndTwoDigestsTransformation;
import net.java.trueupdate.core.zip.patch.EntryNameFilter;
import net.java.trueupdate.core.zip.patch.IdentityTransformation;
import net.java.trueupdate.core.zip.patch.InvalidZipPatchFileException;
import net.java.trueupdate.core.zip.patch.JarPatch;
import net.java.trueupdate.core.zip.patch.MissingZipEntryException;
import net.java.trueupdate.core.zip.patch.NoDirectoryEntryNameFilter;
import net.java.trueupdate.core.zip.patch.Transformation;
import net.java.trueupdate.core.zip.patch.WrongInputZipFile;
import net.java.trueupdate.core.zip.patch.WrongMessageDigestException;
import net.java.trueupdate.shed.Objects;

@NotThreadSafe
public abstract class ZipPatch {
    private DiffModel model;

    @WillNotClose
    abstract ZipFile inputArchive();

    @WillNotClose
    abstract ZipFile patchArchive();

    public static Builder builder() {
        return new Builder();
    }

    public void applyTo(Sink outputArchive) throws IOException {
        final EntryNameFilter[] passFilters = this.passFilters();
        if (null == passFilters || 0 >= passFilters.length) {
            throw new IllegalStateException("At least one pass filter is required to output anything.");
        }
        class ApplyPatchZipTask
        implements ZipOutputTask<Void, IOException> {
            ApplyPatchZipTask() {
            }

            @Override
            public Void execute(ZipOutputStream zipOut) throws IOException {
                for (EntryNameFilter filter : passFilters) {
                    ZipPatch.this.applyTo(new NoDirectoryEntryNameFilter(filter), zipOut);
                }
                return null;
            }
        }
        ZipSinks.execute(new ApplyPatchZipTask()).on(this.newZipOutputStream(outputArchive));
    }

    @CreatesObligation
    ZipOutputStream newZipOutputStream(Sink outputArchive) throws IOException {
        return new ZipOutputStream(outputArchive.output());
    }

    ZipEntry newZipEntry(String name) {
        return new ZipEntry(name);
    }

    EntryNameFilter[] passFilters() {
        return new EntryNameFilter[]{new AcceptAllEntryNameFilter()};
    }

    private void applyTo(final EntryNameFilter filter, final @WillNotClose ZipOutputStream zipOut) throws IOException {
        final MessageDigest digest = this.digest();
        abstract class PatchSet {
            final /* synthetic */ EntryNameFilter val$filter;
            final /* synthetic */ MessageDigest val$digest;
            final /* synthetic */ ZipOutputStream val$zipOut;

            PatchSet() {
                this.val$filter = entryNameFilter;
                this.val$digest = messageDigest;
                this.val$zipOut = zipOutputStream;
            }

            abstract ZipFile archive();

            abstract IOException ioException(Throwable var1);

            final <T> PatchSet apply(Transformation<T> transformation, Iterable<T> iterable) throws IOException {
                for (T item : iterable) {
                    EntryNameAndDigest entryNameAndDigest = transformation.apply(item);
                    String name = entryNameAndDigest.name();
                    if (!this.val$filter.accept(name)) continue;
                    ZipEntry entry = this.archive().getEntry(name);
                    if (null == entry) {
                        throw this.ioException(new MissingZipEntryException(name));
                    }
                    try {
                        class ZipEntrySink
                        implements Sink {
                            final EntryNameAndDigest entryNameAndDigest;
                            final /* synthetic */ ZipOutputStream val$zipOut;
                            final /* synthetic */ MessageDigest val$digest;

                            ZipEntrySink(EntryNameAndDigest entryNameAndDigest) {
                                this.val$zipOut = zipOutputStream;
                                this.val$digest = messageDigest;
                                assert (null != entryNameAndDigest);
                                this.entryNameAndDigest = entryNameAndDigest;
                            }

                            @Override
                            public OutputStream output() throws IOException {
                                ZipEntry entry = ZipPatch.this.newZipEntry(this.entryNameAndDigest.name());
                                if (entry.isDirectory()) {
                                    entry.setMethod(0);
                                    entry.setSize(0L);
                                    entry.setCompressedSize(0L);
                                    entry.setCrc(0L);
                                }
                                this.val$zipOut.putNextEntry(entry);
                                this.val$digest.reset();
                                return new DigestOutputStream(this.val$zipOut, this.val$digest){

                                    @Override
                                    public void close() throws IOException {
                                        ((ZipOutputStream)this.out).closeEntry();
                                        if (!this.valueOfDigest().equals(entryNameAndDigest.digest())) {
                                            throw new WrongMessageDigestException(entryNameAndDigest.name());
                                        }
                                    }

                                    String valueOfDigest() {
                                        return MessageDigests.valueOf(this.digest);
                                    }
                                };
                            }
                        }
                        Copy.copy(new ZipEntrySource(entry, this.archive()), new ZipEntrySink(ZipPatch.this, entryNameAndDigest, this.val$zipOut, this.val$digest));
                    }
                    catch (WrongMessageDigestException ex) {
                        throw this.ioException(ex);
                    }
                }
                return this;
            }
        }
        class InputArchivePatchSet
        extends PatchSet {
            InputArchivePatchSet() {
                super(ZipPatch.this, entryNameFilter, messageDigest, zipOutputStream);
            }

            @Override
            ZipFile archive() {
                return ZipPatch.this.inputArchive();
            }

            @Override
            IOException ioException(Throwable cause) {
                return new WrongInputZipFile(this.archive().getName(), cause);
            }
        }
        new InputArchivePatchSet().apply(new IdentityTransformation(), this.diffModel().unchangedEntries());
        class PatchArchivePatchSet
        extends PatchSet {
            PatchArchivePatchSet() {
                super(ZipPatch.this, entryNameFilter, messageDigest, zipOutputStream);
            }

            @Override
            ZipFile archive() {
                return ZipPatch.this.patchArchive();
            }

            @Override
            IOException ioException(Throwable cause) {
                return new InvalidZipPatchFileException(this.archive().getName(), cause);
            }
        }
        new PatchArchivePatchSet().apply(new EntryNameAndTwoDigestsTransformation(), this.diffModel().changedEntries());
        new PatchArchivePatchSet().apply(new IdentityTransformation(), this.diffModel().addedEntries());
    }

    private MessageDigest digest() throws IOException {
        return MessageDigests.create(this.diffModel().digestAlgorithmName());
    }

    private DiffModel diffModel() throws IOException {
        DiffModel model = this.model;
        return null != model ? model : (this.model = this.loadDiffModel());
    }

    private DiffModel loadDiffModel() throws IOException {
        try {
            return DiffModel.decodeFromXml(new ZipEntrySource(this.diffModelZipEntry(), this.patchArchive()));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidZipPatchFileException(this.patchArchive().getName(), ex);
        }
    }

    private ZipEntry diffModelZipEntry() throws IOException {
        String name = "META-INF/diff.xml";
        ZipEntry entry = this.patchArchive().getEntry("META-INF/diff.xml");
        if (null == entry) {
            throw new InvalidZipPatchFileException(this.patchArchive().getName(), new MissingZipEntryException("META-INF/diff.xml"));
        }
        return entry;
    }

    public static class Builder {
        @CheckForNull
        private ZipFile inputArchive;
        @CheckForNull
        private ZipFile patchArchive;
        private boolean createJar;

        Builder() {
        }

        public Builder inputArchive(@Nullable ZipFile inputArchive) {
            this.inputArchive = inputArchive;
            return this;
        }

        public Builder patchArchive(@Nullable ZipFile patchArchive) {
            this.patchArchive = patchArchive;
            return this;
        }

        public Builder createJar(boolean createJar) {
            this.createJar = createJar;
            return this;
        }

        public ZipPatch build() {
            return Builder.create(this.inputArchive, this.patchArchive, this.createJar);
        }

        private static ZipPatch create(final ZipFile inputArchive, final ZipFile patchArchive, boolean createJarArchive) {
            Objects.requireNonNull((Object)inputArchive);
            Objects.requireNonNull((Object)patchArchive);
            if (createJarArchive) {
                return new JarPatch(){

                    @Override
                    ZipFile inputArchive() {
                        return inputArchive;
                    }

                    @Override
                    ZipFile patchArchive() {
                        return patchArchive;
                    }
                };
            }
            return new ZipPatch(){

                @Override
                ZipFile inputArchive() {
                    return inputArchive;
                }

                @Override
                ZipFile patchArchive() {
                    return patchArchive;
                }
            };
        }
    }
}

