/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.shed.Objects;

public final class ZipEntrySource
implements Source {
    private final ZipEntry entry;
    private final ZipFile file;

    public ZipEntrySource(ZipEntry entry, ZipFile file) {
        this.entry = (ZipEntry)Objects.requireNonNull((Object)entry);
        this.file = (ZipFile)Objects.requireNonNull((Object)file);
    }

    public String name() {
        return this.entry.getName();
    }

    public boolean directory() {
        return this.entry.isDirectory();
    }

    @Override
    public InputStream input() throws IOException {
        return this.file.getInputStream(this.entry);
    }
}

