/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.shed.Objects;

public final class ZipEntrySink
implements Sink {
    private final ZipEntry entry;
    private final ZipOutputStream out;

    public ZipEntrySink(ZipEntry entry, ZipOutputStream out) {
        this.entry = (ZipEntry)Objects.requireNonNull((Object)entry);
        this.out = (ZipOutputStream)Objects.requireNonNull((Object)out);
    }

    public String name() {
        return this.entry.getName();
    }

    public boolean directory() {
        return this.entry.isDirectory();
    }

    @Override
    public OutputStream output() throws IOException {
        if (this.directory()) {
            this.entry.setMethod(0);
            this.entry.setSize(0L);
            this.entry.setCompressedSize(0L);
            this.entry.setCrc(0L);
        }
        this.out.putNextEntry(this.entry);
        return new FilterOutputStream(this.out){

            @Override
            public void close() throws IOException {
                ((ZipOutputStream)this.out).closeEntry();
            }
        };
    }
}

