/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.IOException;
import java.util.zip.ZipOutputStream;
import net.java.trueupdate.core.io.Closeables;
import net.java.trueupdate.core.io.Job;
import net.java.trueupdate.core.io.ZipOutputTask;
import net.java.trueupdate.core.io.ZipSink;
import net.java.trueupdate.core.io.ZipSinks;
import net.java.trueupdate.shed.Objects;

final class WithZipOutputTask<V, X extends Exception>
implements ZipSinks.BindStatement<V, X>,
ZipSinks.ExecuteStatement<V, X> {
    private final ZipOutputTask<V, X> task;

    WithZipOutputTask(ZipOutputTask<V, X> task) {
        this.task = (ZipOutputTask)Objects.requireNonNull(task);
    }

    @Override
    public Job<V, X> to(final ZipSink sink) {
        class WithTaskAndSourceJob
        implements Job<V, X> {
            WithTaskAndSourceJob() {
            }

            @Override
            public V call() throws Exception, IOException {
                return WithZipOutputTask.this.on(sink);
            }
        }
        return new WithTaskAndSourceJob();
    }

    @Override
    public V on(ZipSink sink) throws X, IOException {
        return this.on(sink.output());
    }

    @Override
    public V on(ZipOutputStream out) throws X, IOException {
        return Closeables.execute(this.task, out);
    }
}

