/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.io.InputTask;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.Sources;

@Immutable
public class MessageDigests {
    private MessageDigests() {
    }

    public static MessageDigest sha1() {
        return MessageDigests.create("SHA-1");
    }

    public static MessageDigest create(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String valueOf(MessageDigest digest) {
        return new BigInteger(1, digest.digest()).toString(16);
    }

    public static void updateDigestFrom(MessageDigest digest, Source source) throws IOException {
        class DigestTask
        implements InputTask<Void, IOException> {
            final /* synthetic */ MessageDigest val$digest;

            DigestTask(MessageDigest messageDigest) {
                this.val$digest = messageDigest;
            }

            @Override
            public Void execute(InputStream in) throws IOException {
                int read;
                byte[] buffer = new byte[8192];
                while (0 <= (read = in.read(buffer))) {
                    this.val$digest.update(buffer, 0, read);
                }
                return null;
            }
        }
        Sources.execute(new DigestTask(digest)).on(source);
    }
}

