/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.artifact.impl.maven;

import java.io.File;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;

@Immutable
final class LogRepositoryListener
extends AbstractRepositoryListener {
    private final Logger logger;

    LogRepositoryListener(LoggerFactory factory) {
        this.logger = factory.getLogger(LogRepositoryListener.class.getName());
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        this.logFailure("Invalid artifact descriptor: %s.", event.getArtifact());
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        assert (null == event.getArtifact());
        this.logFailure("Missing artifact descriptor for %s.", event.getArtifact());
    }

    public void metadataInvalid(RepositoryEvent event) {
        this.logFailure("Invalid metadata %s.", event.getMetadata());
    }

    public void artifactResolving(RepositoryEvent event) {
        this.logStartingWorkOnSource(event, "resolve", event.getArtifact(), event.getRepository());
    }

    public void artifactResolved(RepositoryEvent event) {
        this.logFinishedWorkOnSource(event, "resolve", event.getArtifact(), event.getRepository());
    }

    public void metadataResolving(RepositoryEvent event) {
        this.logStartingWorkOnSource(event, "resolve", event.getMetadata(), event.getRepository());
    }

    public void metadataResolved(RepositoryEvent event) {
        this.logFinishedWorkOnSource(event, "resolve", event.getMetadata(), event.getRepository());
    }

    public void artifactDownloading(RepositoryEvent event) {
        this.logStartingWorkOnSource(event, "download", event.getArtifact(), event.getRepository());
    }

    public void artifactDownloaded(RepositoryEvent event) {
        this.logFinishedWorkOnSource(event, "download", event.getArtifact(), event.getRepository());
    }

    public void metadataDownloading(RepositoryEvent event) {
        this.logStartingWorkOnSource(event, "download", event.getMetadata(), event.getRepository());
    }

    public void metadataDownloaded(RepositoryEvent event) {
        this.logFinishedWorkOnSource(event, "download", event.getMetadata(), event.getRepository());
    }

    public void artifactInstalling(RepositoryEvent event) {
        this.logStartingWorkOnDestination(event, "install", event.getArtifact(), event.getFile());
    }

    public void artifactInstalled(RepositoryEvent event) {
        this.logFinishedWorkOnDestination(event, "install", event.getArtifact(), event.getFile());
    }

    public void metadataInstalling(RepositoryEvent event) {
        this.logStartingWorkOnDestination(event, "install", event.getMetadata(), event.getFile());
    }

    public void metadataInstalled(RepositoryEvent event) {
        this.logFinishedWorkOnDestination(event, "install", event.getMetadata(), event.getFile());
    }

    public void artifactDeploying(RepositoryEvent event) {
        this.logStartingWorkOnDestination(event, "deploy", event.getArtifact(), event.getRepository());
    }

    public void artifactDeployed(RepositoryEvent event) {
        this.logFinishedWorkOnDestination(event, "deploy", event.getArtifact(), event.getRepository());
    }

    public void metadataDeploying(RepositoryEvent event) {
        this.logStartingWorkOnDestination(event, "deploy", event.getMetadata(), event.getRepository());
    }

    public void metadataDeployed(RepositoryEvent event) {
        this.logFinishedWorkOnDestination(event, "deploy", event.getMetadata(), event.getRepository());
    }

    private void logFailure(String messageFormat, Object item) {
        if (this.isWarnEnabled()) {
            this.warn(LogRepositoryListener.format(messageFormat, LogRepositoryListener.describe(item)));
        }
    }

    private void logStartingWorkOnSource(RepositoryEvent event, String verb, Object item, Object source) {
        if (this.isDebugEnabled()) {
            this.debug(LogRepositoryListener.startingWorkOnSourceMessage(event, verb, item, source));
        }
    }

    private static String startingWorkOnSourceMessage(RepositoryEvent event, String verb, Object item, Object source) {
        return LogRepositoryListener.formatWorkOnSourceMessage(LogRepositoryListener.startingWorkMessageFormat(event, verb), LogRepositoryListener.describe(item), LogRepositoryListener.describe(source));
    }

    private void logFinishedWorkOnSource(RepositoryEvent event, String verb, Object item, Object source) {
        if (LogRepositoryListener.isFailure(event)) {
            this.warnFinishedWorkOnSource(event, verb, item, source);
        } else {
            this.debugFinishedWorkOnSource(event, verb, item, source);
        }
    }

    private void warnFinishedWorkOnSource(RepositoryEvent event, String verb, Object item, Object source) {
        if (this.isWarnEnabled()) {
            this.warn(LogRepositoryListener.finishedWorkOnSourceMessage(event, verb, item, source));
        }
    }

    private void debugFinishedWorkOnSource(RepositoryEvent event, String verb, Object item, Object source) {
        if (this.isDebugEnabled()) {
            this.debug(LogRepositoryListener.finishedWorkOnSourceMessage(event, verb, item, source));
        }
    }

    private static String finishedWorkOnSourceMessage(RepositoryEvent event, String verb, Object item, Object source) {
        return LogRepositoryListener.formatWorkOnSourceMessage(LogRepositoryListener.finishedWorkMessageFormat(event, verb), LogRepositoryListener.describe(item), LogRepositoryListener.describe(source));
    }

    private void logStartingWorkOnDestination(RepositoryEvent event, String verb, Object item, Object destination) {
        if (this.isDebugEnabled()) {
            this.debug(LogRepositoryListener.startingWorkOnDestinationMessage(event, verb, item, destination));
        }
    }

    private static String startingWorkOnDestinationMessage(RepositoryEvent event, String verb, Object item, Object destination) {
        return LogRepositoryListener.formatWorkOnDestinationMessage(LogRepositoryListener.startingWorkMessageFormat(event, verb), LogRepositoryListener.describe(item), LogRepositoryListener.describe(destination));
    }

    private void logFinishedWorkOnDestination(RepositoryEvent event, String verb, Object item, Object destination) {
        if (LogRepositoryListener.isFailure(event)) {
            this.warnFinishedWorkOnDestination(event, verb, item, destination);
        } else {
            this.debugFinishedWorkOnDestination(event, verb, item, destination);
        }
    }

    private void warnFinishedWorkOnDestination(RepositoryEvent event, String verb, Object item, Object destination) {
        if (this.isWarnEnabled()) {
            this.warn(LogRepositoryListener.finishedWorkOnDestinationMessage(event, verb, item, destination));
        }
    }

    private void debugFinishedWorkOnDestination(RepositoryEvent event, String verb, Object item, Object destination) {
        if (this.isDebugEnabled()) {
            this.debug(LogRepositoryListener.finishedWorkOnDestinationMessage(event, verb, item, destination));
        }
    }

    private static String finishedWorkOnDestinationMessage(RepositoryEvent event, String verb, Object item, Object source) {
        return LogRepositoryListener.formatWorkOnDestinationMessage(LogRepositoryListener.finishedWorkMessageFormat(event, verb), LogRepositoryListener.describe(item), LogRepositoryListener.describe(source));
    }

    private static String startingWorkMessageFormat(RepositoryEvent event, String verb) {
        return "Starting to " + verb + " %s.";
    }

    private static String finishedWorkMessageFormat(RepositoryEvent event, String verb) {
        return (LogRepositoryListener.isFailure(event) ? "Failed" : "Succeeded") + " to " + verb + " %s.";
    }

    private static boolean isFailure(RepositoryEvent event) {
        return !event.getExceptions().isEmpty();
    }

    private static String formatWorkOnSourceMessage(String messageFormat, String item, String source) {
        return LogRepositoryListener.expandAndFormat("%s from %s", messageFormat, item, source);
    }

    private static String formatWorkOnDestinationMessage(String messageFormat, String item, String destination) {
        return LogRepositoryListener.expandAndFormat("%s to %s", messageFormat, item, destination);
    }

    private static String expandAndFormat(String expansionFormat, String messageFormat, Object ... args) {
        return LogRepositoryListener.format(LogRepositoryListener.expand(expansionFormat, messageFormat, args), args);
    }

    private static String expand(String expansionFormat, String messageFormat, Object ... args) {
        return LogRepositoryListener.hasSecondArg(args) ? LogRepositoryListener.format(messageFormat, expansionFormat) : messageFormat;
    }

    private static boolean hasSecondArg(Object ... args) {
        return 2 <= args.length && LogRepositoryListener.nonEmpty(args[1]);
    }

    private static boolean nonEmpty(Object object) {
        return null != object && !object.toString().isEmpty();
    }

    @Nullable
    private static String describe(@CheckForNull Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof Artifact) {
            return "artifact " + object;
        }
        if (object instanceof Metadata) {
            return "metadata " + object;
        }
        if (object instanceof ArtifactRepository) {
            return "repository " + object;
        }
        if (object instanceof File) {
            return "file " + object;
        }
        return object.toString();
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    private boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    private boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    private void warn(String message) {
        this.logger.warn(message);
    }

    private void debug(String message) {
        this.logger.debug(message);
    }
}

