/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.artifact.impl.maven;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.trueupdate.artifact.impl.maven.AhcWagonProvider;
import net.java.trueupdate.artifact.impl.maven.ArtifactConverters;
import net.java.trueupdate.artifact.impl.maven.LegacySlf4jLoggerFactory;
import net.java.trueupdate.artifact.impl.maven.LocalRepositoryAdapter;
import net.java.trueupdate.artifact.impl.maven.LogRepositoryListener;
import net.java.trueupdate.artifact.impl.maven.LogTransferListener;
import net.java.trueupdate.artifact.impl.maven.RemoteRepositoryAdapter;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.artifact.spec.ArtifactResolver;
import net.java.trueupdate.core.codec.JaxbCodec;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.shed.Objects;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.connector.file.FileRepositoryConnectorFactory;
import org.eclipse.aether.connector.wagon.WagonProvider;
import org.eclipse.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.version.Version;

@XmlRootElement(name="repositories")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Immutable
public final class MavenArtifactResolver
implements ArtifactResolver {
    @XmlJavaTypeAdapter(value=LocalRepositoryAdapter.class)
    private final LocalRepository local;
    @XmlElement(name="remote")
    @XmlJavaTypeAdapter(value=RemoteRepositoryAdapter.class)
    private final List<RemoteRepository> remotes;
    private volatile transient ServiceLocator serviceLocator;
    private volatile transient RepositorySystemSession repositorySystemSession;

    private MavenArtifactResolver() {
        this.local = null;
        this.remotes = null;
    }

    public MavenArtifactResolver(LocalRepository local, RemoteRepository ... remotes) {
        this(local, Arrays.asList(remotes));
    }

    public MavenArtifactResolver(LocalRepository local, List<RemoteRepository> remotes) {
        this.local = (LocalRepository)Objects.requireNonNull((Object)local);
        this.remotes = Collections.unmodifiableList(new ArrayList<RemoteRepository>(remotes));
    }

    public LocalRepository localRepository() {
        return this.local;
    }

    public List<RemoteRepository> remoteRepositories() {
        return this.remotes;
    }

    public File resolveArtifactFile(ArtifactDescriptor descriptor) throws Exception {
        return this.resolveArtifact(descriptor).getFile();
    }

    private Artifact resolveArtifact(ArtifactDescriptor descriptor) throws RepositoryException {
        return this.resolveArtifact(ArtifactConverters.artifact(descriptor));
    }

    private Artifact resolveArtifact(Artifact artifact) throws RepositoryException {
        ArtifactResult artifactResult = this.resolveArtifact(this.artifactRequest(artifact));
        Artifact resolved = artifactResult.getArtifact();
        if (null == resolved) {
            throw new ArtifactResolutionException(Arrays.asList(artifactResult), "Artifact not found.");
        }
        return resolved;
    }

    public String resolveUpdateVersion(ArtifactDescriptor descriptor) throws Exception {
        return this.resolveUpdateArtifact(descriptor).getVersion();
    }

    private Artifact resolveUpdateArtifact(ArtifactDescriptor descriptor) throws RepositoryException {
        try {
            return this.resolveUpdateArtifact(ArtifactConverters.updateRangeArtifact(descriptor));
        }
        catch (VersionRangeResolutionException ex) {
            this.resolveArtifact(descriptor);
            throw ex;
        }
    }

    private Artifact resolveUpdateArtifact(Artifact updateRangeArtifact) throws RepositoryException {
        VersionRangeResult result = this.resolveVersionRange(this.versionRangeRequest(updateRangeArtifact));
        Version highestVersion = result.getHighestVersion();
        if (null == highestVersion) {
            throw new VersionRangeResolutionException(result, "Update artifact not found.");
        }
        return updateRangeArtifact.setVersion(highestVersion.toString());
    }

    private VersionRangeResult resolveVersionRange(VersionRangeRequest request) throws VersionRangeResolutionException {
        return this.repositorySystem().resolveVersionRange(this.repositorySystemSession(), request);
    }

    private ArtifactResult resolveArtifact(ArtifactRequest request) throws ArtifactResolutionException {
        return this.repositorySystem().resolveArtifact(this.repositorySystemSession(), request);
    }

    private VersionRangeRequest versionRangeRequest(Artifact artifact) {
        return new VersionRangeRequest().setRepositories(this.remoteRepositories()).setArtifact(artifact);
    }

    private ArtifactRequest artifactRequest(Artifact artifact) {
        return new ArtifactRequest().setRepositories(this.remoteRepositories()).setArtifact(artifact);
    }

    private RepositorySystemSession repositorySystemSession() {
        RepositorySystemSession rss = this.repositorySystemSession;
        return null != rss ? rss : (this.repositorySystemSession = this.newRepositorySystemSession());
    }

    private RepositorySystemSession newRepositorySystemSession() {
        LoggerFactory loggerFactory = this.loggerFactory();
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession().setTransferListener((TransferListener)new LogTransferListener(loggerFactory)).setRepositoryListener((RepositoryListener)new LogRepositoryListener(loggerFactory));
        session.setLocalRepositoryManager(this.repositorySystem().newLocalRepositoryManager((RepositorySystemSession)session, this.localRepository()));
        return session;
    }

    private RepositorySystem repositorySystem() {
        return (RepositorySystem)this.serviceLocator().getService(RepositorySystem.class);
    }

    private LoggerFactory loggerFactory() {
        return (LoggerFactory)this.serviceLocator().getService(LoggerFactory.class);
    }

    private ServiceLocator serviceLocator() {
        ServiceLocator sl = this.serviceLocator;
        return null != sl ? sl : (this.serviceLocator = MavenArtifactResolver.newServiceLocator());
    }

    private static ServiceLocator newServiceLocator() {
        DefaultServiceLocator sl = MavenRepositorySystemUtils.newServiceLocator().addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class).addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class).setServices(WagonProvider.class, (Object[])new WagonProvider[]{new AhcWagonProvider()});
        sl.setErrorHandler(MavenArtifactResolver.errorHandler());
        if (LegacySlf4jLoggerFactory.AVAILABLE) {
            sl.setService(LoggerFactory.class, LegacySlf4jLoggerFactory.class);
        }
        return sl;
    }

    private static DefaultServiceLocator.ErrorHandler errorHandler() {
        return new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                throw new UndeclaredThrowableException(exception);
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MavenArtifactResolver)) {
            return false;
        }
        MavenArtifactResolver that = (MavenArtifactResolver)obj;
        return this.localRepository().equals((Object)that.localRepository()) && ((Object)this.remoteRepositories()).equals(that.remoteRepositories());
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.localRepository().hashCode();
        hash = 31 * hash + ((Object)this.remoteRepositories()).hashCode();
        return hash;
    }

    public static URL mainRepositoriesResource() {
        return MavenArtifactResolver.class.getResource("main-repositories.xml");
    }

    public static MavenArtifactResolver decodeFromXml(Source source) throws Exception {
        return (MavenArtifactResolver)new JaxbCodec(MavenArtifactResolver.jaxbContext()).decode(source, MavenArtifactResolver.class);
    }

    public static JAXBContext jaxbContext() {
        return Lazy.JAXB_CONTEXT;
    }

    private static class Lazy {
        static final JAXBContext JAXB_CONTEXT;

        private Lazy() {
        }

        static {
            try {
                JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{MavenArtifactResolver.class});
            }
            catch (JAXBException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }
}

