/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.artifact.impl.maven;

import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.artifact.impl.maven.TransferRate;
import net.java.trueupdate.artifact.impl.maven.TransferSize;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

@Immutable
final class LogTransferListener
extends AbstractTransferListener {
    private final Logger logger;

    LogTransferListener(LoggerFactory factory) {
        this.logger = factory.getLogger(LogTransferListener.class.getName());
    }

    public void transferInitiated(TransferEvent event) {
        if (this.isDebugEnabled()) {
            this.debug(new Message(event).transferInitiated());
        }
    }

    public void transferSucceeded(TransferEvent event) {
        if (this.isDebugEnabled()) {
            this.debug(new Message(event).transferSucceeded());
        }
    }

    public void transferFailed(TransferEvent event) {
        if (this.isWarnEnabled()) {
            this.warn(new Message(event).transferFailed());
        }
    }

    private boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    private boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    private void warn(String message) {
        this.logger.warn(message);
    }

    private void debug(String message) {
        this.logger.debug(message);
    }

    @Immutable
    private static final class Message {
        private final TransferEvent event;

        Message(TransferEvent event) {
            assert (null != event);
            this.event = event;
        }

        String transferInitiated() {
            return this.format(this.initiatedFormat());
        }

        String transferSucceeded() {
            long bytes = this.event.getTransferredBytes();
            TransferSize size = new TransferSize(bytes);
            TransferRate rate = new TransferRate(bytes, this.durationMillis());
            return this.format(this.succeededFormat(), this.resourceUrlString(), size.toString(Locale.ENGLISH), rate.toString(Locale.ENGLISH));
        }

        String transferFailed() {
            return this.format(this.failedFormat());
        }

        private long durationMillis() {
            return System.currentTimeMillis() - this.resource().getTransferStartTime();
        }

        private String format(String format) {
            return this.format(format, this.resourceUrlString());
        }

        private String format(String format, Object ... args) {
            return String.format(Locale.ENGLISH, format, args);
        }

        private String resourceUrlString() {
            TransferResource resource = this.resource();
            return resource.getRepositoryUrl() + resource.getResourceName();
        }

        private TransferResource resource() {
            return this.event.getResource();
        }

        private String initiatedFormat() {
            return this.isUpload() ? "Starting to upload %s." : "Starting to download %s.";
        }

        private String succeededFormat() {
            return this.isUpload() ? "Succeeded to upload %s: %s at %s." : "Succeeded to download %s: %s at %s.";
        }

        private String failedFormat() {
            return this.isUpload() ? "Failed to upload %s." : "Failed to download %s.";
        }

        private boolean isUpload() {
            return TransferEvent.RequestType.PUT.equals((Object)this.event.getRequestType());
        }
    }
}

