/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.artifact.impl.maven;

import java.io.Serializable;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;

@Immutable
class TransferSize
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final double amount;
    private final TransferUnit unit;

    public TransferSize(long sizeBytes) {
        if (0L > sizeBytes) {
            throw new IllegalArgumentException();
        }
        TransferUnit[] units = TransferUnit.values();
        int i = units.length;
        while (0 <= --i) {
            TransferUnit unit = units[i];
            if (sizeBytes < unit.threshold()) continue;
            this.amount = (double)sizeBytes / unit.quotient();
            this.unit = unit;
            return;
        }
        throw new AssertionError();
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        return this.unit.format(locale, this.amount);
    }

    private static final class TransferUnit
    extends Enum<TransferUnit> {
        public static final /* enum */ TransferUnit bytes = new TransferUnit(0L);
        public static final /* enum */ TransferUnit KB = new TransferUnit(1024L);
        public static final /* enum */ TransferUnit MB = new TransferUnit(0x100000L);
        public static final /* enum */ TransferUnit GB = new TransferUnit(0x40000000L);
        private final long threshold;
        private static final /* synthetic */ TransferUnit[] $VALUES;

        public static TransferUnit[] values() {
            return (TransferUnit[])$VALUES.clone();
        }

        public static TransferUnit valueOf(String name) {
            return Enum.valueOf(TransferUnit.class, name);
        }

        private TransferUnit(long threshold) {
            assert (0L <= threshold);
            this.threshold = threshold;
        }

        long threshold() {
            return this.threshold;
        }

        double quotient() {
            return 0L != this.threshold ? (double)this.threshold : 1.0;
        }

        String format(Locale locale, double amount) {
            return String.format(locale, "%,.2f %s", amount, this.name());
        }

        static {
            $VALUES = new TransferUnit[]{bytes, KB, MB, GB};
        }
    }
}

